package cn.wise.sc.cement.business.entity;

import java.math.BigDecimal;

import com.baomidou.mybatisplus.annotation.IdType;

import java.time.LocalDate;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;

import java.time.LocalDateTime;
import java.io.Serializable;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 *
 * </p>
 *
 * @author ztw
 * @since 2020-09-03
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Consumables implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * 主键
	 */
	@TableId(value = "id", type = IdType.AUTO)
	private Integer id;

	@ApiModelProperty("易耗品名称")
	private String name;

	@ApiModelProperty("易耗品代号")
	private String code;

	@ApiModelProperty("供应商表id")
	private Integer supplierId;

	@ApiModelProperty("购买厂商名称")
	private String supplierName;

	@ApiModelProperty("位置")
	private String position;

	@ApiModelProperty("采购日期（购买日期）")
	private LocalDate purchaseDate;

	@ApiModelProperty("库存数量 单位：g")
	private BigDecimal stockNum;

	@ApiModelProperty("入库数量 （单位：瓶）")
	@TableField(exist = false)
	private Integer enterNum;

	@ApiModelProperty("多少g/瓶")
	private BigDecimal unitStock;

	@ApiModelProperty("库存提醒数量（少于多少g进行提醒）")
	private BigDecimal leastNum;

	@ApiModelProperty("有效日期")
	private LocalDate validDate;

	@ApiModelProperty("状态（0已作废，1启用中）")
	private Integer status;

	@ApiModelProperty("创建时间")
	private LocalDateTime createTime;

	@ApiModelProperty("备注")
	private String remark;

}
