package cn.wise.sc.cement.business.entity;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 *
 * </p>
 *
 * @author ztw
 * @since 2020-09-01
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class EquipmentScrap implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * 主键
	 */
	@TableId(value = "id", type = IdType.AUTO)
	private Integer id;

	@ApiModelProperty("设备表id")
	private Integer equipmentId;

	@ApiModelProperty("申请人id")
	private Integer userId;

	@ApiModelProperty("报废原因")
	private String scrapReason;

	@ApiModelProperty("报废申请日期")
	private LocalDate scrapDate;

	@ApiModelProperty("审批意见")
	private String opinion;

	@ApiModelProperty("申请结果(0待审批，1已通过，2未通过)")
	private Integer status;

	@ApiModelProperty("创建时间")
	private LocalDateTime createTime;

	@ApiModelProperty("备注")
	private String remark;

}
