package cn.wise.sc.cement.business.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 
 * </p>
 *
 * @author ztw
 * @since 2020-11-02
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Preciprice implements Serializable {

    private static final long serialVersionUID=1L;

      @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 样品名字
     */
    private String sampleName;

    private Integer sex;

    /**
     * 用户id
     */
    private Integer userId;

    /**
     * 样品id
     */
    private Integer sampleId;

    /**
     * 检测/处理Id
     */
    private Integer targetId;

    /**
     * 检测:1  处理:0
     */
    private Integer type;

    /**
     * 工值
     */
    private BigDecimal preciprice;

    /**
     * 考核占比
     */
    private BigDecimal assessRate;

    /**
     * 分析占比
     */
    private BigDecimal analyseRate;

    /**
     * 分样占比
     */
    private BigDecimal separateRate;

    /**
     * 报出分析结果
     */
    private BigDecimal reportedAnalyseResult;

    /**
     * 定额工日
     */
    private BigDecimal quotaDay;

    /**
     * 建议系数
     */
    private BigDecimal coefficient;

    /**
     * 考核工值
     */
    private BigDecimal assessValue;

    /**
     * 报结果占比
     */
    private BigDecimal reportedResultRate;

    /**
     * 时间
     */
    private long createTime;

    /**
     * 项目id
     */
    private Integer entrustId;

    /**
     * 项目id
     */
    private String entrustName;

    /**
     * 项目编号
     */
    private String entrustCode;

    /**
     * 账号
     */
    private String account;

    /**
     * 职位
     */
    private String position;

    /**
     * 部门id
     */
    private Integer groupId;

    private String userName;

    /**
     * 检测组名
     */
    private String groupTeamName;
    /**
     * 是否加急 0:不加急  1:加急
     */
    private Integer isUrgent;
}
