package cn.wise.sc.cement.business.entity;

import com.baomidou.mybatisplus.annotation.IdType;

import java.time.LocalDate;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;

import java.io.Serializable;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 *
 * </p>
 *
 * @author ztw
 * @since 2020-10-12
 */
@Data
@ApiModel("审核")
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class QualityApply implements Serializable {

	private static final long serialVersionUID = 1L;
	/**
	 * 项目名
	 */
	@ApiModelProperty("项目名字")
	private String projectName;
	/**
	 * 项目id
	 */
	@ApiModelProperty("项目id")
	private Integer projectId;

	@TableId(value = "id", type = IdType.AUTO)
	private Integer id;
	/**
	 * 来样编号
	 */
	@ApiModelProperty("来样编号")
	private String sampleCode;
	/**
	 * 本所编号
	 */
	@ApiModelProperty("本所编号")
	private String cementCode;
	/**
	 * 部门名
	 */
	@ApiModelProperty("部门名")
	@TableField(exist = false)
	private String groupName;
	/**
	 * 样品状态
	 */
	@ApiModelProperty("样品状态")
	private String sampleForm;
	/**
	 * 计算结果
	 */
	@ApiModelProperty("输入结果")
	private String inputResult;
	/**
	 * 检测项id
	 */
	@ApiModelProperty("检测项id")
	private Integer teamGroupId;
	/**
	 * 时间
	 */
	@ApiModelProperty("项目时间")
	private LocalDate createTime;
	/**
	 * 1:人工检测 2:标准 3:误差
	 */
	@ApiModelProperty("1:人工检测 2:标准 3:误差")
	private Integer status;

	/**
	 * 样品名称
	 */
	@ApiModelProperty("样品名称")
	private String sampleName;
	/**
	 * 检测项名
	 */
	@ApiModelProperty("检测项名")
	private String teams;
	@ApiModelProperty("检测人")
	private String userName;
	@ApiModelProperty("userId")
	private Integer userId;
	@ApiModelProperty("部门")
	@TableField(exist = false)
	private String positionName;
}
