package cn.wise.sc.cement.business.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;

/**
 * @description: 质量检测详情
 * @author: qh
 * @create: 2020-09-28 14:01
 **/
@Data
@ApiModel("质量检测详情实体")
public class QualityDetail implements Serializable {

	private static final long serialVersionUID = 42L;
	@ApiModelProperty("样品名字")
	private String sampleName;
	@ApiModelProperty("检测数据")
	private String inputResult;
	@ApiModelProperty("检测组名字")
	private String teamGroupName;
	@ApiModelProperty("项目编号")
	private String entrustCode;
	@ApiModelProperty("项目名字")
	private String projectName;
	@ApiModelProperty("委托人名字")
	private String sendName;
	@ApiModelProperty("委托人电话")
	private String sendPhone;
	@ApiModelProperty("样品id")
	private Integer sampleId;
	@ApiModelProperty("项目id")
	private Integer entrustId;
	@ApiModelProperty("检测组id")
	private Integer teamGroupId;
	@ApiModelProperty("用户id")
	private Integer userId;
	@ApiModelProperty("样品数量")
	private Integer sampleNum;
	@ApiModelProperty("送检单位id")
	private Integer clientId;
	@ApiModelProperty("用户名")
	private String userName;
	@ApiModelProperty("送检单位名字")
	private String clientName;
	@ApiModelProperty("委托创建时间")
	private LocalDate createTime;
	@ApiModelProperty("来样编号")
	private String sampleCode;
	@ApiModelProperty("样品状态")
	private String sampleForm;
	@ApiModelProperty("本所编号")
	private String cementCode;
}
