package cn.wise.sc.cement.business.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;

import java.time.LocalDateTime;
import java.io.Serializable;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 *
 * </p>
 *
 * @author ztw
 * @since 2020-08-24
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class SysLogs implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * 主键
	 */
	@TableId(value = "id", type = IdType.AUTO)
	private Integer id;

	@ApiModelProperty("操作用户")
	private Integer userId;

	@ApiModelProperty("日志类型（1委托详情）")
	private Integer objType;

	@ApiModelProperty("对象表id（委托表id）")
	private Integer objId;

	@ApiModelProperty("操作内容")
	private String module;

	@ApiModelProperty("操作状态1成功,0失败")
	private Integer flag;

	@ApiModelProperty("创建时间")
	private LocalDateTime createTime;

	@ApiModelProperty("备注")
	private String remark;

	public interface ObjType {
		int SYSTEM_LOG = 0;
		int ENTRUST_LOG = 1;
	}

}
