package cn.wise.sc.cement.business.entity;

import java.math.BigDecimal;

import cn.wise.sc.cement.business.model.BaseEntity;
import cn.wise.sc.cement.business.model.query.ProjectQuery;
import cn.wise.sc.cement.business.model.query.TeamQuery;
import cn.wise.sc.cement.business.model.vo.ClientVo;
import cn.wise.sc.cement.business.model.vo.TeamVo;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;

import java.io.Serializable;
import java.time.LocalDateTime;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.beans.BeanUtils;

/**
 * <p>
 * 检测项
 * </p>
 *
 * @author ztw
 * @since 2020-08-18
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Team extends BaseEntity implements Serializable {

	private static final long serialVersionUID = 1L;

	@TableId(value = "id", type = IdType.AUTO)
	private Integer id;

	@ApiModelProperty("检测项目")
	private String name;

	@ApiModelProperty("检测组表id")
	private Integer groupId;

	@ApiModelProperty("检测依据表id  1、2、3")
	private String methodId;

	@ApiModelProperty("检测依据编号 11、22、33")
	private String number;

	@ApiModelProperty("检测依据名称  a、b、c")
	private String methodName;

	@ApiModelProperty("收费标准")
	private BigDecimal charge;

	/*@ApiModelProperty("建议产值")
	private BigDecimal proCharge;*/

	@ApiModelProperty("资质范围（1资质内，0资质外）")
	private Integer qualifications;

	@ApiModelProperty("状态 0:禁用 1:激活")
	private Integer status;

	@ApiModelProperty("委托是否可见 0:不可见 1:可见")
	private Integer isDisplay;

	@ApiModelProperty("创建时间")
	private LocalDateTime createTime;

	@ApiModelProperty("备注")
	private String remark;

	@ApiModelProperty("处理项表id")
	private Integer handleId;

}
