package cn.wise.sc.cement.business.exception;

import org.springframework.http.HttpStatus;

/**
 * @author shulidong
 * @since 2019/2/19/0019 16:48
 **/
public abstract class BusinessOldException extends RuntimeException {
	protected HttpStatus statusCode = HttpStatus.INTERNAL_SERVER_ERROR;

	private String errorCode;

	public HttpStatus getStatusCode() {
		return statusCode;
	}

	public void setStatusCode(HttpStatus statusCode) {
		this.statusCode = statusCode;
	}

	public BusinessOldException(String errorCode, String message) {
		super(message);
		this.errorCode = errorCode;
	}

	public BusinessOldException(String message, Throwable e) {
		super(message, e);
	}

	public BusinessOldException(String message) {
		super(message);
	}

	public String getErrorCode() {
		return errorCode;
	}

	public void setErrorCode(String errorCode) {
		this.errorCode = errorCode;
	}
}
