package cn.wise.sc.cement.business.mapper;

import cn.wise.sc.cement.business.entity.Client;
import cn.wise.sc.cement.business.entity.ItemDistribution;
import cn.wise.sc.cement.business.entity.ItemDistributionSample;
import cn.wise.sc.cement.business.model.vo.ClientVo;
import cn.wise.sc.cement.business.model.vo.DataStatisticsTeamVo;
import cn.wise.sc.cement.business.model.vo.DataStatisticsVo;
import cn.wise.sc.cement.business.model.vo.EntrustVo;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * Mapper 接口
 * </p>
 *
 * @author ztw
 * @since 2020-08-07
 */
public interface DataStatisticsMapper  {

	List<DataStatisticsVo> countTeamByTime(@Param("params") Map<String, Object> params);

	List<DataStatisticsVo> countTeamByOrigin(@Param("params") Map<String, Object> params);

	List<DataStatisticsVo> countEntrustStatus(@Param("params") Map<String, Object> params);

	List<DataStatisticsVo> countEntrustType(@Param("params") Map<String, Object> params);

	IPage<EntrustVo> countEntrustPage(@Param("page") Page page);

	IPage<DataStatisticsVo> countHandlePage(@Param("page") Page page);

	IPage<DataStatisticsVo> countDistributionPage(@Param("page") Page page);

	List<DataStatisticsVo> countTeamIng();

	List<DataStatisticsVo> countTeam(@Param("params") Map<String, Object> params);

	List<DataStatisticsTeamVo> countTeamList();

    IPage<ItemDistribution> countItemDistribution(@Param("page") Page<ItemDistribution> page,
                                                  @Param("start") Date startTime,
                                                  @Param("end") Date endTime,
                                                  @Param("origins") List<String> origins,
                                                  @Param("itemId") Long itemId);

    ItemDistributionSample countItemDistributionSample(@Param("start") Date startTime, @Param("end") Date endTime,
                                                       @Param("origin") String origin, @Param("teamId") Long teamId);
}
