package cn.wise.sc.cement.business.mapper;

import cn.wise.sc.cement.business.entity.Entrust;
import cn.wise.sc.cement.business.entity.EntrustReport;
import cn.wise.sc.cement.business.entity.QualityDetail;
import cn.wise.sc.cement.business.model.vo.EntrustVo;
import cn.wise.sc.cement.business.model.vo.ProjectVo;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * Mapper 接口
 * </p>
 *
 * @author ztw
 * @since 2020-08-24
 */
public interface EntrustMapper extends BaseMapper<Entrust> {

	IPage<EntrustVo> getPage(@Param("page") Page page, @Param("params") Map<String, Object> params);

	EntrustVo getDetail(Integer id);

	@Select("select count(*) from entrust where day(create_time) = day(now())")
	Integer counts();

	IPage<EntrustVo> getSampleHandlePage(@Param("page") Page page, @Param("params") Map<String, Object> params);

	IPage<EntrustVo> getSampleDistributionPage(@Param("page") Page page, @Param("params") Map<String, Object> params);

	IPage<EntrustVo> getCheckPage(@Param("page") Page page, @Param("params") Map<String, Object> params);

	List<EntrustReport> getReportDetail(@Param("entrustId") Integer entrustId);

	List<QualityDetail> getQualityDetail(@Param("entrustId") Integer entrustId);

	List<Map<String, Object>> exportList(@Param("params") Map<String, Object> params);

}
