package cn.wise.sc.cement.business.mapper;

import cn.wise.sc.cement.business.entity.SysPermission;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import io.swagger.models.auth.In;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

import java.util.List;
import java.util.Set;

/**
 * <p>
 * Mapper 接口
 * </p>
 *
 * @author ztw
 * @since 2020-08-20
 */
public interface SysPermissionMapper extends BaseMapper<SysPermission> {

	@Select("select distinct sp.* from sys_permission sp " +
			"inner join sys_role_permission rp on sp.id = rp.permission_id " +
			"inner join sys_role_user ru on ru.role_id = rp.role_id " +
			"where ru.user_id = #{userId} order by sp.parent_id,sp.sort")
	List<SysPermission> listByUserId(Integer userId);

	@Select("select p.* from sys_permission p inner join sys_role_permission rp on p.id = rp.permission_id where rp.role_id = #{roleId} order by p.parent_id, p.sort")
	List<SysPermission> listByRoleId(Integer roleId);

	@Select("select * from sys_permission t where t.id = #{id}")
	SysPermission getById(Integer id);

}
