package cn.wise.sc.cement.business.mapper;

import cn.wise.sc.cement.business.entity.SysRole;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * <p>
 * Mapper 接口
 * </p>
 *
 * @author ztw
 * @since 2020-08-20
 */
public interface SysRoleMapper extends BaseMapper<SysRole> {

	int saveRolePermission(@Param("roleId") Integer roleId, @Param("permissionIds") List<Integer> permissionIds);

	@Delete("delete from sys_role_permission where role_id = #{roleId}")
	int deleteRolePermission(Integer roleId);

	@Select("select * from sys_role r inner join sys_role_user ru on r.id = ru.role_id where ru.user_id = #{userId}")
	SysRole byUserId(Integer userId);

	@Select("select count(*) from sys_role_user t where t.role_id = #{id}")
	Integer getUserByRoleId(@Param("id") Integer id);

}
