package cn.wise.sc.cement.business.model;

import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 分页查询参数
 *
 * @author zhutianwei
 * <p>
 * 说明： 页码start 每页返回数量 length 其他筛选字段按照对象传入 sql：limit start*length  length
 * 时间筛选 beginTime  endTime
 * 排序 orderBy   例如order by payTime desc
 */
public class PageTableRequest implements Serializable {

	private static final long serialVersionUID = 7328071045193618467L;

	@ApiModelProperty("当前页数(从1开始)")
	private Long current;
	@ApiModelProperty("当前每页显示数")
	private Long size;

	public Long getCurrent() {
		return current;
	}

	public void setCurrent(Long current) {
		this.current = current;
	}

	public Long getSize() {
		return size;
	}

	public void setSize(Long size) {
		this.size = size;
	}

}
