package cn.wise.sc.cement.business.model.query;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.util.List;

/**
 * @description:
 * @author: ztw
 * @create: 2020-08-07 14:58
 **/
@Data
@ApiModel("委托评审请求")
public class ApprovalQuery {
	@ApiModelProperty("委托表id")
	private Integer id;

	@ApiModelProperty("项目类型(常规项目，科研项目，质量控制项目)")
	private String projectType;

	@ApiModelProperty("样品处理要求完成日期")
	private LocalDate finishDate;

	@ApiModelProperty("样品及检测项列表")
	private List<SampleQuery> sampleList;

	@ApiModelProperty("是否同意 1同意，2拒绝")
	private Integer isAgree;

	@ApiModelProperty("审批意见")
	private String auditReason;

}
