package cn.wise.sc.cement.business.model.query;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.NonNull;
import lombok.RequiredArgsConstructor;

import javax.validation.constraints.NotEmpty;
import java.time.LocalDate;

/**
 * @description: 历史档案
 * @author: wlb
 * @create: 2020-09-17
 **/
@Data
@RequiredArgsConstructor
@NoArgsConstructor
@ApiModel("历史档案")
public class HistoryArchivesQuery {
	private Integer id;

	@ApiModelProperty(name = "time", value = "日期")
	@NotEmpty(message = "日期不能为空!")
	@NonNull
	private LocalDate time;

	@ApiModelProperty(name = "type", value = "类型")
	@NotEmpty(message = "类型不能为空!")
	@NonNull
	private String type;

	@ApiModelProperty(name = "content", value = "内容")
	@NotEmpty(message = "内容不能为空!")
	@NonNull
	private String content;

	@ApiModelProperty(name = "remark", value = "备注")
	private String remark;

	@ApiModelProperty(name = "userId", value = "用户id")
	private Integer userId;
}
