package cn.wise.sc.cement.business.model.query;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.RequiredArgsConstructor;

import java.time.LocalDate;

/**
 * @description: 非标产值
 * @author: wlb
 * @create: 2020-09-17
 **/
@Data
@RequiredArgsConstructor
@ApiModel("非标产值")
public class NonStandardValueQuery {
	private Integer id;

	@ApiModelProperty(name = "name", value = "姓名")
	private String name;

	@ApiModelProperty(name = "account", value = "账户")
	private String account;

	@ApiModelProperty(name = "statistical", value = "起止日期")
	private String statistical;

	@ApiModelProperty(name = "approvalHours", value = "审批工时")
	private Double approvalHours;

	@ApiModelProperty(name = "status", value = "状态 0:未提交 1：待审批 2：已通过 3：未通过")
	private Integer status;

//	@ApiModelProperty(name = "appraisalValue", value = "考核公值")
//	private Double appraisalValue;

	@ApiModelProperty(name = "finalValue", value = "最终产值")
	private Double finalValue;

	@ApiModelProperty(name = "workType", value = "工作类别")
	private String workType;

	@ApiModelProperty(name = "workDescription", value = "工作描述")
	private String workDescription;

	@ApiModelProperty(name = "startTime", value = "开始时间")
	private LocalDate startTime;

	@ApiModelProperty(name = "userId", value = "用户id")
	private Integer userId;
}
