package cn.wise.sc.cement.business.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @description:
 * @author: ztw
 * @create: 2020-08-07 15:09
 **/

@Data
@ApiModel("设备维修计划Vo")
public class PlanEquipmentRepairVo {

	@ApiModelProperty("设备维修计划Id")
	private Integer id;

	@ApiModelProperty("产品名称")
	private String name;

	@ApiModelProperty("规格型号")
	private String model;

	@ApiModelProperty("技术指标")
	private String technicalIndex;

	@ApiModelProperty("单价（万元）")
	private BigDecimal unitPrice;

	@ApiModelProperty("生产单位")
	private String productionUnit;

	@ApiModelProperty("维修日期")
	private LocalDate repairDate;

	@ApiModelProperty("创建人id")
	private Integer userId;

	@ApiModelProperty("创建人姓名")
	private String userName;

	@ApiModelProperty("维修人id")
	private Integer repairerId;

	@ApiModelProperty("设备维修人姓名")
	private String repairerName;

	@ApiModelProperty("状态（0待完成，1已完成）")
	private Integer status;

	@ApiModelProperty("实施情况")
	private String implementation;

	@ApiModelProperty("创建时间")
	private LocalDateTime createTime;

	@ApiModelProperty("备注")
	private String remark;

}
