package cn.wise.sc.cement.business.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @description:
 * @author: qh
 * @create: 2020-08-07 14:58
 **/
@Data
@ApiModel("样品及检测项 正式表Vo")
public class SampleVo {

	@ApiModelProperty("样品表id")
	private Integer id;

	@ApiModelProperty("来样编号")
	private String sampleCode;

	@ApiModelProperty("样品名")
	private String name;

	@ApiModelProperty("样品状态（粉、块状)")
	private String sampleForm;

	@ApiModelProperty("检测项id 例子：1、2、3")
	private String teamIds;

	@ApiModelProperty("检测项名称")
	private String teamName;

	@ApiModelProperty("样品照片")
	private String samplePhoto;

	@ApiModelProperty("样品重量")
	private BigDecimal weight;

	@ApiModelProperty("样品重量计量单位（1微克，2毫克，3克，4千克，5吨）")
	private Integer weightType;

	@ApiModelProperty("(检测依据编号)  例子：01、23、15")
	private String methodNumbers;

	@ApiModelProperty("是否平行样（1是，0否）")
	private Integer isParallel;

	@ApiModelProperty("平行样编号")
	private String parallelCode;

	@ApiModelProperty("本所编号")
	private String cementCode;

	@ApiModelProperty("收费标准")
	private BigDecimal charge;

	@ApiModelProperty("产值")
	private BigDecimal outputValue;

	@ApiModelProperty("委托表id")
	private Integer entrustId;

	@ApiModelProperty("检测项目列表")
	private List<SampleDistributionTeamVo> sampleDistributionTeamVoList;

	//样品管理列表信息
	@ApiModelProperty("样品登记操作人id")
	private Integer operatorId;

	@ApiModelProperty("样品登记时间")
	private LocalDateTime registerTime;

	@ApiModelProperty("处理提醒时间")
	private LocalDate handleDate;

	@ApiModelProperty("小样位置")
	private String littlePosition;

	@ApiModelProperty("原样位置")
	private String originalPosition;

	@ApiModelProperty("（0未领用，1已领用，2已销毁）")
	private Integer status;

	@ApiModelProperty("销毁时间")
	private LocalDateTime destructionTime;

	@ApiModelProperty("项目id")
	private Integer projectId;

	@ApiModelProperty("项目名称")
	private String projectName;

	@ApiModelProperty("项目编号")
	private String projectCode;

	@ApiModelProperty("样品处理是否全部完成（0未处理完成，1处理完成")
	private Integer isHandle;

	@ApiModelProperty("样品是否检测完成（0未检测完成， 1检测完成，）")
	private Integer isDistribution;

	@ApiModelProperty("样品是否校核完成（0未检测完成， 1检测完成，）")
	private Integer isCheck;

	@ApiModelProperty("产地")
	private String origin;

	private String createTime;

}
