package cn.wise.sc.cement.business.service;

import cn.wise.sc.cement.business.entity.Entrust;
import cn.wise.sc.cement.business.entity.SampleDistribution;
import cn.wise.sc.cement.business.entity.SampleHandleEnclosure;
import cn.wise.sc.cement.business.model.*;
import cn.wise.sc.cement.business.model.query.*;
import cn.wise.sc.cement.business.model.vo.*;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import io.swagger.models.auth.In;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author ztw
 * @since 2021-01-12
 */
public interface IDataStatisticsService {

	BaseResponse<Map<String, String>> countOverview();

	BaseResponse<List<DataStatisticsVo>> countTeamByTime(Integer cycle, String startDate, String endDate);

	BaseResponse<List<DataStatisticsVo>> countTeamByOrigin(Integer cycle, String startDate, String endDate);

	BaseResponse<Map<String, Object>> countEntrustStatus(Integer cycle, String startDate, String endDate);

	BaseResponse<IPage<EntrustVo>> countEntrustPage(PageQuery pageQuery);

	BaseResponse<Map<String, Object>> countTaskIng(PageQuery pageQuery);

	BaseResponse<List<DataStatisticsVo>> countTeamIng();

	BaseResponse<List<DataStatisticsVo>> countTeamDetail(Integer cycle, String startDate, String endDate);

	BaseResponse<List<DataStatisticsTeamVo>> countTeamList();

	/**
	 * 导出检查项分布统计
	 * @param query    请求参数
	 * @param response 响应
	 * @return 返回的统计
	 */
    BaseResponse<Page<ItemDistributionVo>> countItemDistribution(CountItemDistributionQuery query, HttpServletResponse response);
}
