package cn.wise.sc.cement.business.service;

import cn.wise.sc.cement.business.entity.Entrust;
import cn.wise.sc.cement.business.entity.EntrustReport;
import cn.wise.sc.cement.business.entity.SampleDistribution;
import cn.wise.sc.cement.business.entity.SampleHandleEnclosure;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.IndustrialReport;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.ReportDetailVo;
import cn.wise.sc.cement.business.model.SixElementReport;
import cn.wise.sc.cement.business.model.query.*;
import cn.wise.sc.cement.business.model.vo.*;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;

import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author ztw
 * @since 2020-08-24
 */
public interface IEntrustService extends IService<Entrust> {

	BaseResponse<IPage<EntrustVo>> getPage(PageQuery pageQuery, String entrustCode, String startDate, String endDate, Integer status,
	                                       String clientName, String projectName, String projectCode, Integer isUrgent);

	BaseResponse<String> setTopping(Integer id);

	BaseResponse<Entrust> create(EntrustQuery query);

	BaseResponse<String> deleteSample(Integer sampleId);

	BaseResponse<EntrustVo> getDtail(Integer id);

	BaseResponse<EntrustVo> getDetailCapacity(Integer id);

	BaseResponse<String> getMaxCementCode();

	BaseResponse<String> approval(ApprovalQuery query);

//	BaseResponse<String> handle(HandleQuery query);

	BaseResponse<IPage<EntrustVo>> getSampleHandlePage(PageQuery pageQuery, String entrustCode, Integer status,
	                                                   String clientName, String projectName, String projectCode, Integer isUrgent);

	BaseResponse<Map<String, Object>> getSampleHandleList(Integer id);

	BaseResponse<String> acceptHandle(Integer[] ids);

	BaseResponse<List<SampleHandleEnclosureVo>> getSampleHandleEnclosureList(Integer sampleHandleId);

	BaseResponse<SampleHandleEnclosure> uploadEnclosureCL(SampleHandleEnclosureQuery query);

	BaseResponse<SampleHandleVo> getHandleDtail(Integer id);

	BaseResponse<String> finishHandle(Integer[] ids);

	BaseResponse<String> distribution(DistributionQuery query);

	BaseResponse<IPage<EntrustVo>> getSampleDistributionPage(PageQuery pageQuery, String entrustCode, Integer status,
	                                                         String clientName, String projectName, String projectCode, Integer isUrgent);

	BaseResponse<Map<String, Object>> getSampleDistributionList(Integer id);

	BaseResponse<String> acceptDistribution(Integer[] ids);

	BaseResponse<SampleDistribution> uploadEnclosurePF(SampleDistributionEnclosureQuery query);

	BaseResponse<String> finishDistribution(Integer[] ids);

	BaseResponse<IPage<EntrustVo>> getCheckPage(PageQuery pageQuery, String startDate, String endDate, Integer status,
	                                            Integer clientId, String projectName, String projectCode);

	BaseResponse<Map<String, Object>> getCheckList(Integer id);

	BaseResponse<List<SampleCheckVo>> getCheckDetail(String cementCode);

	BaseResponse<List<SampleDistribution>> getEnclosureList(Integer sampleId, Integer teamGroupId, Integer userId);

	BaseResponse<Map<String, Object>> checkCount(CheckCountQuery query);

	/*BaseResponse<String> check(CheckQuery query);*/

	BaseResponse<IPage<EntrustVo>> getReportPage(PageQuery pageQuery, String startDate,
	                                             String endDate, Integer clientId,
	                                             String projectName, String projectCode);

	BaseResponse<Boolean> deleteById(Integer id);

	ReportDetailVo getReportDetail(Integer entrustId);

	BaseResponse<IPage<EntrustVo>> getQualityPage(PageQuery pageQuery,
	                                              String startDate, String endDate,
	                                              Integer clientId, String projectName,
	                                              String projectCode);

	QualityDetailVo getQualityDetail(Integer entrustId);

	void export(String startDate, String endDate, Integer status,
	            Integer clientId, String projectName, String projectCode,
	            String fileName, HttpServletResponse response);

	BaseResponse<EntrustVo> getBaseDtail(Integer id);

	BaseResponse<EntrustVo> getBaseDtailClient(Integer id);

	BaseResponse<List<SampleHandleVo>> getSampleHandleDtail(Integer id);

	BaseResponse<List<SampleHandleEnclosureVo>> getSampleHandleDtailEnclosureList(Integer sampleHandleId);

	BaseResponse<List<SampleVo>> getSampleCheckDtail(Integer id);

	/**
	 * 查询六元素的检测结果
	 *
	 * @param entrustId 委托id
	 * @return 六元素校核
	 */
	List<SixElementReport> getSampleSixElementCheck(Integer entrustId);

	/**
	 * 查询工业特性
	 *
	 * @param entrustId 委托id
	 * @return 工业特征
	 */
	List<IndustrialReport> getSampleIndustrialCheck(Integer entrustId);
}
