package cn.wise.sc.cement.business.service;

import cn.wise.sc.cement.business.entity.AppraisalValue;
import cn.wise.sc.cement.business.entity.NonStandardApproval;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.query.NonStandardApprovalQuery;
import cn.wise.sc.cement.business.model.vo.NonStandardApplyVo;
import cn.wise.sc.cement.business.model.vo.NonStandardApprovalVo;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author wlb
 * @since 2020-09-23
 */
public interface INonStandardApprovalService extends IService<NonStandardApproval> {
	/**
	 * 获取分页
	 *
	 * @param pageQuery 非标产值审批信息分页
	 * @return IPage<NoneStandardApproval>
	 */
	BaseResponse<IPage<NonStandardApprovalVo>> getPage(PageQuery pageQuery, String name, Integer status);

	/**
	 * 获取所有非标产值审批信息
	 *
	 * @return List
	 */
	BaseResponse<List<NonStandardApprovalVo>> getList();

	/**
	 * 通过id查询非标产值审批信息
	 *
	 * @return List
	 */
	BaseResponse<List<NonStandardApprovalVo>> getById(Integer id);

	/**
	 * 审批通过或驳回请求实现
	 *
	 * @param query
	 * @return NoneStandardApprovalVo
	 */
	BaseResponse<NonStandardApproval> update(NonStandardApprovalQuery query);

	/**
	 * 修改考核公值
	 *
	 *
	 * @return AppraisalValue
	 */
	BaseResponse<Double> updateAppraisal(Double appraisalValue);

	/**
	 * 获取考核公值
	 *
	 *
	 * @return AppraisalValue
	 */
	BaseResponse<Double> getAppraisalValue();


	/**
	 * 通过id删除指定审批信息
	 *
	 * @param id
	 * @return NoneStandardApplyVo
	 */
	BaseResponse delete(Integer id);

	/**
	 * 更改状态信息，达到改变显示的效果
	 * 1：未提交
	 * 2：已通过
	 * 3：未通过
	 *
	 * @param status 状态
	 * @param id     id
	 * @return Boolean
	 */
	BaseResponse<String> status(Integer status, Integer id);

	/**
	 * 非标产值审批列表导出
	 *
	 * @param filename 文件名
	 * @param userId   账户
	 * @param name     姓名
	 * @param response
	 */
	void exportList(String filename, String userId, String name, HttpServletResponse response);
}
