package cn.wise.sc.cement.business.service;

import cn.wise.sc.cement.business.entity.NonStandardValue;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.vo.NonStandardApplyVo;
import cn.wise.sc.cement.business.model.vo.NonStandardValueVo;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;

import javax.servlet.http.HttpServletResponse;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author wlb
 * @since 2020-09-23
 */
public interface INonStandardValueService extends IService<NonStandardValue> {
	/**
	 * 获取分页
	 *
	 * @param pageQuery 非标产值信息分页
	 * @return IPage<NoneStandardValue>
	 */
	BaseResponse<IPage<NonStandardValueVo>> getPage(PageQuery pageQuery, Integer userId, String name,Date startParse,Date endParse);


/*	//计算每个用户提交的非标产值
	BaseResponse<List<NonStandardValue>> nonValue(Integer userId);*/

	//计算每个用户提交的非标产值
	BaseResponse<List<NonStandardValue>> nonValue(Date start, Date end, Integer groups,String name);

//	/**
//	 * 通过用户id查询非标产值信息
//	 *
//	 * @return List
//	 */
//	BaseResponse<List<NonStandardValueVo>> getByUserId(Integer userId);

    /**
     * 获取所有非标产值信息
     *
     * @return List
     */
    BaseResponse<List<NonStandardValueVo>> getList(Date start, Date end, Integer groups, String name);

    /**
     * 非标产值列表导出
     *
     * @param filename 文件名
     * @param userId   用户id
     * @param name     姓名
     * @param response
     */
    void exportList(String filename, Integer userId, String name, HttpServletResponse response);
}
