package cn.wise.sc.cement.business.service;

import cn.wise.sc.cement.business.entity.PlanPeople;
import cn.wise.sc.cement.business.entity.PlanTraining;
import cn.wise.sc.cement.business.entity.SampleDistribution;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.query.PlanPeopleQuery;
import cn.wise.sc.cement.business.model.query.SampleDistributionEnclosureQuery;
import cn.wise.sc.cement.business.model.vo.PlanPeopleVo;
import cn.wise.sc.cement.business.model.vo.PlanTrainingVo;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

public interface IPlanPeopleService extends IService<PlanPeople> {
	/**
	 * 获取分页
	 *
	 * @param pageQuery 培训计划分页
	 * @return IPage<PlanTraining>
	 */
	BaseResponse<IPage<PlanPeopleVo>> getPage(PageQuery pageQuery, Integer planId);

	/**
	 * 获取指定时间内的培训计划
	 *
	 * @return List
	 */
	BaseResponse<List<PlanPeople>> getList();

	/**
	 * 更改状态信息，达到改变显示的效果
	 * 1：通过
	 *
	 * @param status 状态
	 * @param id     id
	 * @return Boolean
	 */
	BaseResponse<String> status(Integer status, Integer id);

	/**
	 * 培训计划上传附件
	 *
	 * @param query
	 * @return
	 */
	BaseResponse<PlanPeople> uploadPlanPF(PlanPeopleQuery query);

	/**
	 * 同步历史档案
	 *
	 * @param id
	 * @return
	 */
	BaseResponse synchronization(Integer id);
}
