package cn.wise.sc.cement.business.service;

import cn.wise.sc.cement.business.entity.PlanTraining;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.query.PlanTrainingQuery;
import cn.wise.sc.cement.business.model.vo.PlanTrainingVo;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;

import javax.servlet.http.HttpServletResponse;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author wlb
 * @since 2020-10-19
 */
public interface IPlanTrainingService extends IService<PlanTraining> {
	/**
	 * 获取分页
	 *
	 * @param pageQuery 培训计划分页
	 * @return IPage<PlanTraining>
	 */
	BaseResponse<IPage<PlanTrainingVo>> getPage(PageQuery pageQuery);

	/**
	 * 获取指定时间内的培训计划
	 *
	 * @return List
	 */
	BaseResponse<List<PlanTrainingVo>> getList(Date start, Date end);

	/**
	 * 通过id查询指定培训计划
	 *
	 * @return List
	 */
	BaseResponse<List<PlanTrainingVo>> getById(Integer id);

	/**
	 * 添加培训
	 *
	 * @param query
	 * @return PlanTrainingVo
	 */
	BaseResponse<PlanTraining> create(PlanTrainingQuery query);

	/**
	 * 编辑培训计划
	 *
	 * @param planTrainingQuery
	 * @return PlanTrainingVo
	 */
	BaseResponse<PlanTraining> update(PlanTrainingQuery planTrainingQuery);

	/**
	 * 检测培训计划是否开始
	 *
	 * @return String
	 */
	BaseResponse<String> checkplanDate();

	/**
	 * 更改状态信息，达到改变显示的效果
	 * 1：未通过
	 *
	 * @param status 状态
	 * @param id     id
	 * @return Boolean
	 */
//	BaseResponse<String> status(Integer status, Integer id);

	/**
	 * 通过id删除指定培训计划
	 *
	 * @param id
	 * @return PlanTrainingVo
	 */
	BaseResponse delete(Integer id);

	/**
	 * 培训计划导出
	 *
	 * @param objective 培训目的
	 * @param filename  文件名
	 * @param response
	 */
	void exportList(String filename,HttpServletResponse response);

}
