package cn.wise.sc.cement.business.service;

import cn.wise.sc.cement.business.entity.QualityApply;
import com.baomidou.mybatisplus.extension.service.IService;

import javax.servlet.http.HttpServletResponse;
import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author ztw
 * @since 2020-10-12
 */
public interface IQualityApplyService extends IService<QualityApply> {

	/**
	 * 查询质量检测审核状态
	 *
	 * @param projectIds 项目id
	 * @return 已检测的质量监控
	 */
	Set<Integer> selectQualityApplyStatusByProIds(List<Integer> projectIds);

	/**
	 * 导出质量检测详情
	 *
	 * @param startParse 开始时间
	 * @param endParse   结束时间
	 */
	void exportQuality(Date startParse, Date endParse, HttpServletResponse response);
}
