package cn.wise.sc.cement.business.service;

import cn.wise.sc.cement.business.entity.Sample;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.query.SampleManageQuery;
import cn.wise.sc.cement.business.model.vo.SampleVo;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;

import javax.servlet.http.HttpServletResponse;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author ztw
 * @since 2020-08-24
 */
public interface ISampleService extends IService<Sample> {

	BaseResponse<IPage<SampleVo>> getPage(PageQuery pageQuery, String sampleName, String cementCode);

	BaseResponse<SampleVo> getDetail(Integer id);

	BaseResponse<String> register(SampleManageQuery query);

	BaseResponse<String> destruction(Integer id);

	void export(String sampleName, String cementCode,
	            String fileName, HttpServletResponse response);

	/**
	 * 绑定位置信息
	 *
	 * @param query 小样绑定位置信息
	 * @return 成功与否
	 */
	BaseResponse<String> bindSavePosition(SampleManageQuery query);

	/**
	 * 样品复查
	 *
	 * @param id 样品id
	 * @return 复查成功与否
	 */
	BaseResponse<Boolean> ampleReview(Integer id);

	/**
	 * 下载样品存储信息
	 * @param response  响应体
	 */
    void upload(HttpServletResponse response);

	/**
	 * 导出样品销毁记录 word
	 * @param response
	 */
	void exportWord(String sampleName, String cementCode,
	                String fileName, HttpServletResponse response);
}
