package cn.wise.sc.cement.business.service;

import cn.wise.sc.cement.business.entity.EntityEnclosure;
import cn.wise.sc.cement.business.entity.GroupStandard;
import cn.wise.sc.cement.business.entity.Standard;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.query.ChangeStockQuery;
import cn.wise.sc.cement.business.model.query.ChangeValidDateQuery;
import cn.wise.sc.cement.business.model.query.StandardQuery;
import cn.wise.sc.cement.business.model.vo.StandardValueVo;
import cn.wise.sc.cement.business.model.vo.StandardVo;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author ztw
 * @since 2020-09-04
 */
public interface IStandardService extends IService<Standard> {

	BaseResponse<IPage<Standard>> getPage(PageQuery pageQuery, String name, String supplierName);

	void export(String name, String supplierName, String fileName, HttpServletResponse response);

	BaseResponse<Standard> create(StandardQuery query);

	BaseResponse<Standard> update(StandardQuery query);

	BaseResponse<List<EntityEnclosure>> getHistoryStandard(Integer id);

	BaseResponse<StandardVo> getDetail(Integer id);

	BaseResponse<String> enter(ChangeStockQuery query);

	BaseResponse<String> out(ChangeStockQuery query);

	BaseResponse<String> checkStockNum();

	BaseResponse<String> changeValidDate(ChangeValidDateQuery query);

	BaseResponse<String> overdue(Integer id);

	BaseResponse<List<StandardValueVo>> getStandardDetailList();

	/**
	 * 按检测组获取标样信息
	 * @return GroupStandard
	 */
    List<GroupStandard> getStandards(String name);
}
