package cn.wise.sc.cement.business.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import cn.wise.sc.cement.business.entity.*;
import cn.wise.sc.cement.business.mapper.*;
import cn.wise.sc.cement.business.model.*;
import cn.wise.sc.cement.business.model.query.*;
import cn.wise.sc.cement.business.model.vo.*;
import cn.wise.sc.cement.business.service.*;
import cn.wise.sc.cement.business.util.CheckCountUtil;
import cn.wise.sc.cement.business.util.DateUtil;
import cn.wise.sc.cement.business.util.ExcelUtil;
import cn.wise.sc.cement.business.util.RedisUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import io.swagger.models.auth.In;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author ztw
 * @since 2021-01-12
 */
@Service
public class DataStatisticsServiceImpl implements IDataStatisticsService {


    @Resource
    private DataStatisticsMapper dataStatisticsMapper;
    @Autowired
    private IProjectService projectService;
    @Autowired
    private IEquipmentService equipmentService;
    @Autowired
    private ISampleService sampleService;
    @Autowired
    private IEntrustService entrustService;
    @Autowired
    private CommonServiceImpl commonService;
    @Autowired
    private ISampleHandleService sampleHandleService;
    @Autowired
    private ISampleDistributionService sampleDistributionService;


    /**
     * 统计概览-重要数值统计
     * @return
     */
    @Override
    public BaseResponse<Map<String, String>> countOverview() {
        Map<String, String> map = new HashMap<>();
        //当前进行的项目
        QueryWrapper<Project> projectWrapper = new QueryWrapper<>();
        projectWrapper.eq("status", 1);
        Integer projectCounts = projectService.count(projectWrapper);
        map.put("projectCounts", projectCounts.toString());

        //实验设备总量
        QueryWrapper<Equipment> equipmentWrapper = new QueryWrapper<>();
        Integer equipmentCounts = equipmentService.count(equipmentWrapper);
        map.put("equipmentCounts", equipmentCounts.toString());

        //样品库存总量
        QueryWrapper<Sample> sampleWrapper = new QueryWrapper<>();
        sampleWrapper.ne("status", 2);
        Integer sampleCounts = sampleService.count(sampleWrapper);
        map.put("sampleCounts", sampleCounts.toString());

        //委托单数量
        QueryWrapper<Entrust> entrustWrapper = new QueryWrapper<>();
        Integer entrustCounts = entrustService.count(entrustWrapper);
        map.put("entrustCounts", entrustCounts.toString());

        return BaseResponse.okData(map);
    }

    /**
     * 检测项数量统计-按时间
     * @param cycle
     * @param startDate
     * @param endDate
     * @return
     */
    @Override
    public BaseResponse<List<DataStatisticsVo>> countTeamByTime(Integer cycle, String startDate, String endDate){
        Map<String, String> dateMap = new HashMap<>();

        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");

        if(startDate != null || endDate != null){
            List<String> dateList = commonService.getMonthBetween(startDate, endDate);
            if(dateList != null && dateList.size()>0){
                for(int i=0; i<dateList.size(); i++ ){
                    dateMap.put(dateList.get(i),"0");
                }
            }

        }else{
            Date date = new Date();//获取当前时间
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);

            for(int i=0; i<12; i++){
                date = calendar.getTime();
                String dateTime =  format.format(date);
                dateMap.put(dateTime,"0");
                calendar.add(Calendar.MONTH, -1);
            }
        }

        Map<String, Object> params = new HashMap<>();
        params.put("cycle", cycle);
        params.put("startDate", startDate);
        params.put("endDate", endDate);
        List<DataStatisticsVo> list = dataStatisticsMapper.countTeamByTime(params);
        for(DataStatisticsVo vo:list){
            if(dateMap.containsKey(vo.getName())){
                dateMap.put(vo.getName(), vo.getValue());
            }
        }
        List<DataStatisticsVo> listResult = new ArrayList<>();
        for(String key:dateMap.keySet()){
            DataStatisticsVo vo = new DataStatisticsVo();
            vo.setName(key);
            vo.setValue(dateMap.get(key));
            listResult.add(vo);
        }

        return BaseResponse.okData(listResult);
    }

    /**
     * 检测项统计-列表
     * @param cycle
     * @param startDate
     * @param endDate
     * @return
     */
    /*public BaseResponse<List<Object>> countTeamByTime(Integer cycle, String startDate, String endDate){



    }*/







    /**
     * 检测项数量统计-按地区
     *
     * @param startDate
     * @param endDate
     * @return
     */
    @Override
    public BaseResponse<List<DataStatisticsVo>> countTeamByOrigin(Integer cycle, String startDate, String endDate) {
        Map<String, Object> params = new HashMap<>();
        params.put("cycle", cycle);
        params.put("startDate", startDate);
        params.put("endDate", endDate);
        List<DataStatisticsVo> list = dataStatisticsMapper.countTeamByOrigin(params);
        return BaseResponse.okData(list);
    }

    /**
     * 项目进展统计
     * @return
     */
    @Override
    public BaseResponse<Map<String, Object>> countEntrustStatus(Integer cycle, String startDate, String endDate){
        Map<String, Object> params = new HashMap<>();
        params.put("cycle", cycle);
        params.put("startDate", startDate);
        params.put("endDate", endDate);

        Map<String, Object> map = new HashMap<>();
        QueryWrapper<Entrust> entrustQw = new QueryWrapper<>();
        Integer sum_counts = entrustService.count(entrustQw);
        if(sum_counts == null){
            map.put("sumCounts", "0");
            map.put("statusList", null);
            map.put("typeList", null);
        }else{
            List<DataStatisticsVo> statusList = dataStatisticsMapper.countEntrustStatus(params);
            List<DataStatisticsVo> typeList = dataStatisticsMapper.countEntrustStatus(params);
            map.put("sumCounts", sum_counts);
            map.put("statusList", statusList);
            map.put("typeList", typeList);
        }
        return BaseResponse.okData(map);
    }

    /**
     * 项目进展统计-列表
     * @param pageQuery
     * @return
     */
    @Override
    public BaseResponse<IPage<EntrustVo>> countEntrustPage(PageQuery pageQuery){
        Page<EntrustVo> page = new Page<>(pageQuery.getPageNo(), pageQuery.getPageSize());
        IPage<EntrustVo> pages = dataStatisticsMapper.countEntrustPage(page);
        return BaseResponse.okData(pages);
    }



    /**
     * 进行中任务数量统计
     * @return
     */
    @Override
    public BaseResponse<Map<String, Object>> countTaskIng(PageQuery pageQuery){
        Map<String, Object> map = new HashMap<>();
        QueryWrapper<SampleHandle> handleQw = new QueryWrapper<>();
        handleQw.eq("status",0).or().eq("status",1);
        Integer handle_counts = sampleHandleService.count(handleQw);
        map.put("handleCounts", handle_counts);

        QueryWrapper<SampleDistribution> distributionQw = new QueryWrapper<>();
        distributionQw.eq("status",0).or().eq("status",1);
        Integer distribution_counts = sampleDistributionService.count(distributionQw);
        map.put("distributionCounts", distribution_counts);
        Page<EntrustVo> page = new Page<>(pageQuery.getPageNo(), pageQuery.getPageSize());

        IPage<DataStatisticsVo> pagesHandle = dataStatisticsMapper.countHandlePage(page);
        map.put("pagesHandle", pagesHandle);

        IPage<DataStatisticsVo> pagesDistribution = dataStatisticsMapper.countDistributionPage(page);
        map.put("pagesDistribution", pagesDistribution);

        return BaseResponse.okData(map);
    }

    /**
     * 正在进行的检测项统计
     * @return
     */
    @Override
    public BaseResponse<List<DataStatisticsVo>> countTeamIng(){
        List<DataStatisticsVo> list = dataStatisticsMapper.countTeamIng();
        return BaseResponse.okData(list);
    }

    /**
     * 检测项数量统计
     * @return
     */
    @Override
    public BaseResponse<List<DataStatisticsVo>> countTeamDetail(Integer cycle, String startDate, String endDate){
        Map<String, Object> params = new HashMap<>();
        params.put("cycle", cycle);
        params.put("startDate", startDate);
        params.put("endDate", endDate);
        List<DataStatisticsVo> list = dataStatisticsMapper.countTeam(params);
        return BaseResponse.okData(list);
    }

    /**
     * 检测项目数量统计-列表
     * @return
     */
    @Override
    public BaseResponse<List<DataStatisticsTeamVo>> countTeamList(){
        List<DataStatisticsTeamVo> list = dataStatisticsMapper.countTeamList();
        return BaseResponse.okData(list);
    }






    @Override
    public BaseResponse<Page<ItemDistributionVo>> countItemDistribution(CountItemDistributionQuery query, HttpServletResponse response) {

        String startTimeStr = query.getStartTime();
        String endTimeStr = query.getEndTime();
        String type = query.getType();
        Long itemId = query.getItemId();

        List<String> origins = query.getOrigins();
        Date startTime = null;
        Date endTime = null;
        Page<ItemDistribution> page = new Page<>(query.getPageQuery().getPageNo(), query.getPageQuery().getPageSize());
        if (StrUtil.isNotEmpty(type)) {
            startTime = DateUtil.getStartTime(Integer.parseInt(type));
            endTime = cn.hutool.core.date.DateUtil.date();
        }
        if (StrUtil.isNotEmpty(startTimeStr)) {
            startTime = cn.hutool.core.date.DateUtil.parseDate(startTimeStr);
        }
        if (StrUtil.isNotEmpty(endTimeStr)) {
            endTime = cn.hutool.core.date.DateUtil.parseDate(endTimeStr);
        }

        //获取检测项目城市分布统计
        IPage<ItemDistribution> list = dataStatisticsMapper
                .countItemDistribution(page, startTime, endTime, origins, itemId);

        List<ItemDistribution> records = list.getRecords();
        if (records.size() == 0) {
            return BaseResponse.errorMsg("没找到数据~");
        }

        List<ItemDistributionVo> rtsRecords = new ArrayList<>(records.size());

        //组装检查项统计和按照样品统计
        for (ItemDistribution distribution : records) {
            String key = distribution.getKey();
            String[] split = key.split(",");
            String teamId = split[0];
            String origin = split[1];
            //检测项按样品分布统计
            ItemDistributionSample sample = dataStatisticsMapper
                    .countItemDistributionSample(startTime, endTime, origin, Long.parseLong(teamId));
            ItemDistributionVo vo = new ItemDistributionVo();
            vo.setOrigin(origin);
            vo.setItemName(sample.getName());
            vo.setSampleCount(sample.getCount());
            vo.setItemCount(distribution.getCount());
            vo.setTime(startTime + "_" + endTime);
            rtsRecords.add(vo);
        }

        Page<ItemDistributionVo> rts = new Page<>();
        rts.setRecords(rtsRecords);
        rts.setCurrent(page.getCurrent());
        rts.setPages(page.getPages());
        rts.setTotal(page.getTotal());
        rts.setSize(page.getSize());

        return BaseResponse.okData(rts);
    }

}
