package cn.wise.sc.cement.business.service.impl;

import cn.wise.sc.cement.business.entity.Handle;
import cn.wise.sc.cement.business.entity.SysRole;
import cn.wise.sc.cement.business.entity.TeamGroup;
import cn.wise.sc.cement.business.mapper.HandleMapper;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.vo.ClientVo;
import cn.wise.sc.cement.business.model.vo.HandleVo;
import cn.wise.sc.cement.business.service.IHandleService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author ztw
 * @since 2020-09-10
 */
@Service
public class HandleServiceImpl extends ServiceImpl<HandleMapper, Handle> implements IHandleService {

	@Resource
	private HandleMapper handleMapper;

	/**
	 * 获取分页
	 *
	 * @param pageQuery
	 * @return
	 */
	@Override
	public BaseResponse<IPage<HandleVo>> getPage(PageQuery pageQuery, String name, String userName) {
		Map<String, Object> params = new HashMap<>();
		params.put("name", name);
		params.put("userName", userName);
		Page<HandleVo> page = new Page<>(pageQuery.getPageNo(), pageQuery.getPageSize());
		IPage<HandleVo> pages = handleMapper.getPage(page, params);
		return BaseResponse.okData(pages);
	}

	/**
	 * 获取详情
	 * @param id
	 * @return
	 */
	@Override
	public BaseResponse<HandleVo> getDetail(Integer id) {
		HandleVo handleVo = handleMapper.getDetail(id);
		if(handleVo == null){
			return BaseResponse.errorMsg("信息错误!");
		}
		return BaseResponse.okData(handleVo);
	}

	/**
	 * 新增处理项
	 *
	 * @param query
	 * @return
	 */
	@Override
	@Transactional
	public BaseResponse<Handle> create(Handle query) {
		if (StringUtils.isEmpty(query.getName())) {
			return BaseResponse.errorMsg("处理项名称不能为空!");
		}
		if (query.getUserId() == null) {
			return BaseResponse.errorMsg("请选择处理人");
		}
		QueryWrapper<Handle> qw = new QueryWrapper<>();
		qw.eq("name", query.getName());
		int count = handleMapper.selectCount(qw);
		if (count > 0) {
			return BaseResponse.errorMsg(query.getName() + "已存在");
		}
		query.setCreateTime(LocalDateTime.now());
		handleMapper.insert(query);
		return BaseResponse.okData(query);
	}

	/**
	 * 修改处理项
	 *
	 * @param query
	 * @return
	 */
	@Override
	@Transactional
	public BaseResponse<Handle> update(Handle query) {
		if (StringUtils.isEmpty(query.getName())) {
			return BaseResponse.errorMsg("处理项名称不能为空!");
		}
		if (query.getUserId() == null) {
			return BaseResponse.errorMsg("请选择处理人");
		}
		Handle handle = handleMapper.selectById(query.getId());
		if(handle == null){
			return BaseResponse.errorMsg("信息错误!");
		}
		QueryWrapper<Handle> qw = new QueryWrapper<>();
		qw.eq("name", query.getName());
		qw.ne("id", query.getId());
		int count = handleMapper.selectCount(qw);
		if (count > 0) {
			return BaseResponse.errorMsg(query.getName() + "已存在");
		}
		handle.setName(query.getName());
		handle.setUserId(query.getUserId());
		handle.setRemark(query.getRemark());
		handleMapper.updateById(handle);
		return BaseResponse.okData(query);
	}

	/**
	 * 删除处理项
	 * @param id
	 * @return
	 */
	@Override
	@Transactional
	public BaseResponse<String> delete(Integer id) {
		Handle handle = handleMapper.selectById(id);
		if (handle == null) {
			return BaseResponse.errorMsg("处理项不存在!");
		}
		Integer conunts = handleMapper.countTeamByhandleId(id);
		if (conunts != 0 && conunts > 0) {
			return BaseResponse.errorMsg(conunts + "个检测项正在使用!");
		}
		handleMapper.deleteById(id);
		return BaseResponse.okData("删除成功");
	}


}
