package cn.wise.sc.cement.business.service.impl;

import cn.hutool.core.util.StrUtil;
import cn.wise.sc.cement.business.entity.Method;
import cn.wise.sc.cement.business.entity.Project;
import cn.wise.sc.cement.business.mapper.MethodMapper;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.query.MethodQuery;
import cn.wise.sc.cement.business.service.IMethodService;
import cn.wise.sc.cement.business.util.ExcelUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author ztw
 * @since 2020-08-18
 */
@Service
public class MethodServiceImpl extends ServiceImpl<MethodMapper, Method> implements IMethodService {

	@Resource
	private MethodMapper methodMapper;

	@Override
	public BaseResponse<IPage<Method>> getPage(PageQuery pageQuery, String name, String standard) {
		QueryWrapper<Method> qw = new QueryWrapper<>();
		qw.orderByDesc("id");
		if (StrUtil.isNotBlank(name)) {
			qw.like("name", name);
		}
		if (StrUtil.isNotBlank(standard)) {
			qw.like("standard", standard);
		}
		IPage<Method> page = new Page<>(pageQuery.getPageNo(), pageQuery.getPageSize());
		page = methodMapper.selectPage(page, qw);
		return BaseResponse.okData(page);
	}

	@Override
	public BaseResponse<List<Method>> getList() {
		QueryWrapper<Method> qw = new QueryWrapper<>();
		List<Method> list = this.list(qw);
		return BaseResponse.okData(list);
	}

	@Override
	public BaseResponse<Method> create(MethodQuery query) {
		if(StringUtils.isBlank(query.getName())){
			return BaseResponse.errorMsg("检测依据名称不能为空!");
		}
		if(query.getName().contains("、") || query.getNumber().contains("、") ){
			return BaseResponse.errorMsg("检测依据名称和编号不能出现特殊符号");
		}
		QueryWrapper<Method> qw = new QueryWrapper<>();
		qw.eq("name", query.getName());
		int count = methodMapper.selectCount(qw);
		if (count > 0) {
			return BaseResponse.errorMsg("检测依据名称已存在!");
		}

		QueryWrapper<Method> qw1 = new QueryWrapper<>();
		qw1.eq("standard", query.getStandard());
		int count1 = methodMapper.selectCount(qw1);
		if (count1 > 0) {
			return BaseResponse.errorMsg("检测依据标准号已存在!");
		}

		QueryWrapper<Method> qw2 = new QueryWrapper<>();
		qw2.eq("number", query.getNumber());
		int count2 = methodMapper.selectCount(qw2);
		if (count2 > 0) {
			return BaseResponse.errorMsg("检测依据编号已存在!");
		}

		Method crate = new Method();
		BeanUtils.copyProperties(query, crate);
		crate.setCreateTime(LocalDateTime.now())
				.setRemark(null);
		methodMapper.insert(crate);
		return BaseResponse.okData(crate);
	}

	@Override
	public BaseResponse<Method> update(MethodQuery query) {
		if(StringUtils.isBlank(query.getName())){
			return BaseResponse.errorMsg("检测依据名称不能为空!");
		}
		if(query.getName().contains("、") || query.getNumber().contains("、") ){
			return BaseResponse.errorMsg("检测依据名称和编号不能出现特殊符号");
		}
		Method oldMethod = methodMapper.selectById(query.getId());
		if(oldMethod==null){
			return BaseResponse.errorMsg("信息错误");
		}
		QueryWrapper<Method> qw = new QueryWrapper<>();
		qw.eq("name", query.getName());
		qw.ne("id", query.getId());
		int count = methodMapper.selectCount(qw);
		if (count > 0) {
			return BaseResponse.errorMsg("检测依据名称已存在!");
		}

		QueryWrapper<Method> qw1 = new QueryWrapper<>();
		qw1.eq("standard", query.getStandard());
		qw1.ne("id", query.getId());
		int count1 = methodMapper.selectCount(qw1);
		if (count1 > 0) {
			return BaseResponse.errorMsg("检测依据标准号已存在!");
		}

		QueryWrapper<Method> qw2 = new QueryWrapper<>();
		qw2.eq("number", query.getNumber());
		qw.ne("id", query.getId());
		int count2 = methodMapper.selectCount(qw2);
		if (count2 > 0) {
			return BaseResponse.errorMsg("检测依据编号已存在!");
		}
		Method update = Method.crate(query);
		update.setId(query.getId());
		this.updateById(update);
		return BaseResponse.okData(update);
	}

	/**
	 * 检测依据导出
	 *
	 * @param name
	 * @param standard
	 * @param fileName
	 * @param response
	 */
	@Override
	public void export(String name, String standard, String fileName, HttpServletResponse response) {
		Map<String, Object> params = new HashMap<>();
		params.put("standard", standard);
		params.put("name", name);
		List<Map<String, Object>> list = methodMapper.exportList(params);

		if (!CollectionUtils.isEmpty(list)) {
			Map<String, Object> map = list.get(0);
			String[] headers = new String[map.size()];
			headers[0] = "序号";
			headers[1] = "检测依据名";
			headers[2] = "标准号";
			headers[3] = "检测依据编号";
			headers[4] = "实施日期";
			headers[5] = "更新日期";
			List<Object[]> datas = new ArrayList<>(list.size());
			for (Map<String, Object> m : list) {
				Object[] objects = new Object[headers.length];
				for (int j = 0; j < headers.length; j++) {
					String obj = m.get(headers[j]).toString();
					if (j == 0) {
						obj = obj.split("\\.")[0];
					}
					objects[j] = obj;
				}
				datas.add(objects);
			}
			ExcelUtil.excelExport(
					fileName == null || fileName.trim().length() <= 0 ? "检测依据" : fileName, headers,
					datas, response);
		}
	}

	@Override
	public BaseResponse delete(Integer id) {
		Method method = methodMapper.selectById(id);
		if (method == null) {
			return BaseResponse.errorMsg("检测依据不存在");
		}
		methodMapper.deleteById(id);
		return BaseResponse.okData("删除成功");
	}

}
