package cn.wise.sc.cement.business.service.impl;

import cn.wise.sc.cement.business.entity.NonStandardValue;
import cn.wise.sc.cement.business.mapper.NonStandardValueMapper;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.vo.NonStandardApplyVo;
import cn.wise.sc.cement.business.model.vo.NonStandardValueVo;
import cn.wise.sc.cement.business.service.INonStandardValueService;
import cn.wise.sc.cement.business.util.ExcelUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import javax.xml.crypto.Data;
import java.util.*;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author wlb
 * @since 2020-09-23
 */
@Service
public class NonStandardValueServiceImpl extends ServiceImpl<NonStandardValueMapper, NonStandardValue> implements INonStandardValueService {

    @Resource
	private NonStandardValueMapper nonStandardValueMapper;

	@Override
	public BaseResponse<IPage<NonStandardValueVo>> getPage(PageQuery pageQuery, Integer userId, String name,Date start, Date end) {
		Map<String, Object> params = new HashMap<>();
		params.put("start", start);
		params.put("end", end);
		params.put("userId", userId);
		params.put("name", name);
		params.put("status",2);
		Page<NonStandardValueVo> page = new Page<>(pageQuery.getPageNo(), pageQuery.getPageSize());
		IPage<NonStandardValueVo> pages = nonStandardValueMapper.getPage(page, params);
		return BaseResponse.okData(pages);
	}

//	public BaseResponse<List<NonStandardValue>> userValue(Date start, Date end,Integer userId){
//		List<NonStandardValueVo> data = getList(start, end, userId).getData();
//		List<NonStandardValue> rts = new ArrayList<>();
//		NonStandardValue finalNonStandardValue = new NonStandardValue();
//		finalNonStandardValue.setFinalValue(0D);
//		for (NonStandardValueVo nonStandardValueVo:data){
//			Double newFinalValue = nonStandardValueVo.getFinalValue() + finalNonStandardValue.getFinalValue();
//			finalNonStandardValue.setFinalValue(newFinalValue);
//		}
//		rts.add(finalNonStandardValue);
//		return BaseResponse.okData(rts);
//	}

	@Override
	//计算每个用户提交的非标产值
	public BaseResponse<List<NonStandardValue>> nonValue(Date start, Date end, Integer groups,String name) {
		List<NonStandardValueVo> data = getList(start, end, groups,name).getData();
		//userId去重
		Set<Integer> ids = new HashSet<>();
		//循环所有NonStandardValue的集合data,找到每个NonStandardValue.getuserId放到set
		//知道有多少个不同的userid==>不同的人
		for (NonStandardValueVo nonStandardValue : data) {
			Integer userId1 = nonStandardValue.getUserId();
			ids.add(userId1);
		}
		List<NonStandardValue> rts = new ArrayList<>();
		//循环每个不同的人 找到他所有的NonStandardValue记录===>根据userId来找
		for (Integer userId1 : ids) {
			//第一次进来 userId=1
			//去data里面找userId==1的所有数据

			//这个是我们要拿到的userId=1时的最终数据
			//李国庆的总工时和总产值
			NonStandardValue finalNonStandardValue = new NonStandardValue();
			//初始化最终结果===>不初始化默认为NULL，不能进行+——*/
			finalNonStandardValue.setId(0);
			finalNonStandardValue.setApprovalHours(0D);
			finalNonStandardValue.setReportedHours(0D);
			finalNonStandardValue.setFinalValue(0D);
			//todo 为当前userID创建一天展示的产值对象 new 产值对象 ===>传出
			for (NonStandardValueVo nonStandardValue : data) {
				//每一次进来拿到都是李国国企的一条记录
				if (nonStandardValue.getUserId().intValue() == userId1) {

					//其他不需要累加的数据==> 比如名字
					finalNonStandardValue.setStatistical(nonStandardValue.getStatistical());
//					finalNonStandardValue.setAppraisalValue(nonStandardValue.getAppraisalValue().doubleValue());
					finalNonStandardValue.setUserId(nonStandardValue.getUserId());
					finalNonStandardValue.setStartTime(nonStandardValue.getStartTime());
					finalNonStandardValue.setWorkType(nonStandardValue.getWorkType());
					finalNonStandardValue.setWorkDescription(nonStandardValue.getWorkDescription());
					finalNonStandardValue.setStatus(nonStandardValue.getStatus());
					finalNonStandardValue.setUserId(nonStandardValue.getUserId());
					finalNonStandardValue.setName(nonStandardValue.getName());
					finalNonStandardValue.setAccount(nonStandardValue.getAccount());
					finalNonStandardValue.setGroups(nonStandardValue.getGroups());
					finalNonStandardValue.setGroupName(nonStandardValue.getGroupName());

					Integer newId = finalNonStandardValue.getId() + 1;
					finalNonStandardValue.setId(newId);

					//只要进来这个if ===> 我拿到了李国庆的其中一条记录
					Double houers = nonStandardValue.getApprovalHours().doubleValue();
					Double newApprovalHours = nonStandardValue.getApprovalHours() + finalNonStandardValue.getApprovalHours();
					//用新得到的最总工时覆盖掉原来的总工时===>累加
					finalNonStandardValue.setApprovalHours(newApprovalHours);

					Double RHhouers = nonStandardValue.getReportedHours().doubleValue();
					Double newReportedHours = nonStandardValue.getReportedHours() + finalNonStandardValue.getReportedHours();
					//用新得到的最总工时覆盖掉原来的总工时===>累加
					finalNonStandardValue.setReportedHours(newReportedHours);

					Double finalValue = nonStandardValue.getFinalValue().doubleValue();
					Double newFinalValue = nonStandardValue.getFinalValue() + finalNonStandardValue.getFinalValue();
					finalNonStandardValue.setFinalValue(newFinalValue);
				}
			}
			rts.add(finalNonStandardValue);
		}
		return BaseResponse.okData(rts);
	}

//	@Override
//	public BaseResponse<List<NonStandardValueVo>> getByUserId(Integer userId) {
//		Map<String, Object> params = new HashMap<>();
//		params.put("userId", userId);
//		List<NonStandardValueVo> list = nonStandardValueMapper.getByUserId(params);
//		return BaseResponse.okData(list);
//	}

	@Override
	public BaseResponse<List<NonStandardValueVo>> getList(Date start, Date end, Integer groups,String name) {
		Map<String, Object> params = new HashMap<>();
		params.put("start", start);
		params.put("end", end);
		params.put("status", 2);
		params.put("groups", groups);
		params.put("name",name);
		List<NonStandardValueVo> list = nonStandardValueMapper.getList(params);
		return BaseResponse.okData(list);
	}

	@Override
	public void exportList(String filename, Integer userId, String name, HttpServletResponse response) {
		Map<String, Object> params = new HashMap<>();
		params.put("userId", userId);
		params.put("name", name);
		List<Map<String, Object>> list = nonStandardValueMapper.exportList(params);

		if (!CollectionUtils.isEmpty(list)) {
			Map<String, Object> map = list.get(0);
			String[] headers = new String[11];
			headers[0] = "序号";
			headers[1] = "姓名";
			headers[2] = "账户";
			headers[3] = "起止日期";
			headers[4] = "上报工日";
			headers[5] = "审批工日";
			headers[6] = "最终产值";
			headers[7] = "工作类别";
			headers[8] = "工作描述";
			headers[9] = "部门id";
			headers[10] = "部门名";

			List<Object[]> datas = new ArrayList<>(list.size());
			for (Map<String, Object> m : list) {
				Object[] objects = new Object[headers.length];
				for (int j = 0; j < headers.length; j++) {
					String obj = m.get(headers[j]) == null ? "" : m.get(headers[j]).toString();
					if (j == 0 && obj != null) {
						obj = obj.split("\\.")[0];
					}
					objects[j] = obj;
				}

				datas.add(objects);
			}
			ExcelUtil.excelExport(
					filename == null || filename.trim().length() <= 0 ? "非标产值" : filename, headers,
					datas, response);
		}
	}
}
