package cn.wise.sc.cement.business.service.impl;

import cn.wise.sc.cement.business.entity.Supplier;
import cn.wise.sc.cement.business.entity.SupplierEnclosure;
import cn.wise.sc.cement.business.entity.SysUserEnclosure;
import cn.wise.sc.cement.business.mapper.SupplierEnclosureMapper;
import cn.wise.sc.cement.business.mapper.SupplierMapper;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.LoginUser;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.query.SupplierQuery;
import cn.wise.sc.cement.business.model.query.SupplierEnclosureQuery;
import cn.wise.sc.cement.business.service.ISupplierService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author ztw
 * @since 2020-09-01
 */
@Service
public class SupplierServiceImpl extends ServiceImpl<SupplierMapper, Supplier> implements ISupplierService {

	@Resource
	private SupplierMapper supplierMapper;
	@Autowired
	private UserServiceImpl userService;
	@Resource
	private SupplierEnclosureMapper supplierEnclosureMapper;

	/**
	 * 获取分页
	 *
	 * @param pageQuery
	 * @param name
	 * @return
	 */
	@Override
	public BaseResponse<IPage<Supplier>> getPage(PageQuery pageQuery, String name) {
		QueryWrapper<Supplier> qw = new QueryWrapper<>();
		if (StringUtils.isNotEmpty(name)) {
			qw.like("name", name);
		}
		qw.orderByDesc("create_time");
		IPage<Supplier> page = new Page<>(pageQuery.getPageNo(), pageQuery.getPageSize());
		page = supplierMapper.selectPage(page, qw);
		return BaseResponse.okData(page);
	}

	/**
	 * 新增供应商
	 *
	 * @param query
	 * @return
	 */
	@Override
	@Transactional
	public BaseResponse<Supplier> create(SupplierQuery query) {
		if (StringUtils.isEmpty(query.getName())) {
			return BaseResponse.errorMsg("供应商名称不能为空!");
		}
		QueryWrapper<Supplier> qw = new QueryWrapper<>();
		qw.eq("name", query.getName());
		int count = supplierMapper.selectCount(qw);
		if (count > 0) {
			return BaseResponse.errorMsg(query.getName() + "已存在");
		}
		Supplier supplier = new Supplier();
		BeanUtils.copyProperties(query, supplier);
		supplier.setCreateTime(LocalDateTime.now());
		supplierMapper.insert(supplier);
		return BaseResponse.okData(supplier);
	}

	/**
	 * 修改供应商
	 *
	 * @param query
	 * @return
	 */
	@Override
	public BaseResponse<Supplier> update(SupplierQuery query) {
		if (StringUtils.isEmpty(query.getName())) {
			return BaseResponse.errorMsg("供应商名称不能为空!");
		}
		QueryWrapper<Supplier> qw = new QueryWrapper<>();
		qw.eq("name", query.getName());
		qw.ne("id", query.getId());
		int count = supplierMapper.selectCount(qw);
		if (count > 0) {
			return BaseResponse.errorMsg(query.getName() + "已存在");
		}
		Supplier supplier = new Supplier();
		BeanUtils.copyProperties(query, supplier);
		supplierMapper.updateById(supplier);
		return BaseResponse.okData(supplier);
	}

	/**
	 * 新增供应商附件信息
	 * @param query
	 * @return
	 */
	@Override
	@Transactional
	public BaseResponse<String> upload(SupplierEnclosureQuery query) {
		LoginUser loginUser = userService.getLoginUser();
		if (loginUser == null) {
			return BaseResponse.errorMsg("请登录账号");
		}
		if (query == null || query.getSupplierId() == null) {
			return BaseResponse.errorMsg("参数错误");
		}
		SupplierEnclosure supplierEnclosure = new SupplierEnclosure();
		supplierEnclosure.setSupplierId(query.getSupplierId())
				.setEnclosureUrl(query.getEnclosureUrl())
				.setExtName(query.getExtName())
				.setAlias(query.getAlias())
				.setFlStatus(1)
				.setUploadTime(LocalDateTime.now());
		supplierEnclosureMapper.insert(supplierEnclosure);
		return BaseResponse.okMsg("成功");
	}

	/**
	 * 附件列表
	 * @param pageQuery
	 * @param supplierId
	 * @return
	 */
	@Override
	public BaseResponse<IPage<SupplierEnclosure>> getEnclosurePage(PageQuery pageQuery, Integer supplierId) {
		if(supplierId == null){
			return BaseResponse.errorMsg("请传入供应商id");
		}
		Map<String, Object> params = new HashMap<>();
		params.put("supplierId", supplierId);
		Page<SupplierEnclosure> page = new Page<>(pageQuery.getPageNo(), pageQuery.getPageSize());
		IPage<SupplierEnclosure> pages = supplierEnclosureMapper.getPage(page, params);
		return BaseResponse.okData(pages);
	}

	/**
	 * 删除供应商附件
	 * @param id
	 * @return
	 */
	@Transactional
	@Override
	public BaseResponse<String> deleteEnclosure(Integer id) {
		if(id == null){
			return BaseResponse.errorMsg("参数错误");
		}
		SupplierEnclosure suppliernclosure = supplierEnclosureMapper.selectById(id);
		if(suppliernclosure == null){
			return BaseResponse.errorMsg("附件信息错误");
		}
		supplierEnclosureMapper.deleteById(id);
		return BaseResponse.okData("附件信息删除成功");
	}





}
