package cn.wise.sc.cement.business.service.impl;

import cn.wise.sc.cement.business.entity.SysRole;
import cn.wise.sc.cement.business.entity.SysUser;
import cn.wise.sc.cement.business.mapper.SysRoleMapper;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.query.RoleQuery;
import cn.wise.sc.cement.business.model.query.UserQuery;
import cn.wise.sc.cement.business.model.vo.ClientVo;
import cn.wise.sc.cement.business.service.ISysRoleService;
import cn.wise.sc.cement.business.wrapper.WrapMapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import jdk.nashorn.internal.ir.annotations.Reference;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author ztw
 * @since 2020-08-20
 */
@Service
public class SysRoleServiceImpl extends ServiceImpl<SysRoleMapper, SysRole> implements ISysRoleService {

	@Resource
	private SysRoleMapper roleMapper;

	/**
	 * 获取分页
	 *
	 * @param pageQuery
	 * @param name
	 * @return
	 */
	@Override
	public BaseResponse<IPage<SysRole>> getPage(PageQuery pageQuery, String name) {
		QueryWrapper<SysRole> qw = new QueryWrapper<>();
		if (StringUtils.isNotEmpty(name)) {
			qw.like("name", name);
		}
		qw.orderByDesc("create_time");
		IPage<SysRole> page = new Page<>(pageQuery.getPageNo(), pageQuery.getPageSize());
		page = roleMapper.selectPage(page, qw);
		return BaseResponse.okData(page);
	}

	/**
	 * 新增角色
	 *
	 * @param query
	 * @return
	 */
	@Override
	@Transactional
	public BaseResponse<SysRole> create(RoleQuery query) {
		if (StringUtils.isEmpty(query.getName())) {
			return BaseResponse.errorMsg("角色名称不能为空!");
		}
		QueryWrapper<SysRole> qw = new QueryWrapper<>();
		qw.eq("name", query.getName());
		int count = roleMapper.selectCount(qw);
		if (count > 0) {
			return BaseResponse.errorMsg(query.getName() + "已存在");
		}
		SysRole role = new SysRole();
		BeanUtils.copyProperties(query, role);
		List<Integer> permissionIds = query.getPermissionIds();
		if(!permissionIds.contains(2)){
			permissionIds.add(2);
		}
		if(!permissionIds.contains(11)){
			permissionIds.add(11);
		}
		role.setStatus(1);
		role.setCreateTime(LocalDateTime.now());
		roleMapper.insert(role);
		if (!CollectionUtils.isEmpty(permissionIds)) {
			roleMapper.saveRolePermission(role.getId(), permissionIds);
		}
		return BaseResponse.okData(role);
	}

	@Override
	@Transactional
	public BaseResponse<SysRole> update(RoleQuery query) {
		if(query.getId() == 1){
			return BaseResponse.errorMsg("系统管理员角色不允许修改!");
		}
		if (StringUtils.isEmpty(query.getName())) {
			return BaseResponse.errorMsg("角色名称不能为空!");
		}
		QueryWrapper<SysRole> qw = new QueryWrapper<>();
		qw.eq("name", query.getName());
		qw.ne("id", query.getId());
		int count = roleMapper.selectCount(qw);
		if (count > 0) {
			return BaseResponse.errorMsg(query.getName() + "已存在");
		}
		SysRole role = new SysRole();
		BeanUtils.copyProperties(query, role);
		List<Integer> permissionIds = query.getPermissionIds();
		if(!permissionIds.contains(2)){
			permissionIds.add(2);
		}
		if(!permissionIds.contains(11)){
			permissionIds.add(11);
		}
		roleMapper.updateById(role);
		roleMapper.deleteRolePermission(role.getId());
		if (!CollectionUtils.isEmpty(permissionIds)) {
			roleMapper.saveRolePermission(role.getId(), permissionIds);
		}
		return BaseResponse.okData(role);
	}

	/**
	 * 根据用户id获取拥有的角色
	 *
	 * @param userId
	 * @return
	 */
	@Override
	public BaseResponse<SysRole> byUserId(Integer userId) {
		if (userId == null) {
			return BaseResponse.errorMsg("用户id不能为空!");
		}
		SysRole role = roleMapper.byUserId(userId);
		return BaseResponse.okData(role);
	}

	/**
	 * 删除角色
	 *
	 * @param id
	 * @return
	 */
	@Override
	@Transactional
	public BaseResponse<String> delete(Integer id) {
		if(id == 1){
			return BaseResponse.errorMsg("系统管理员角色不允许删除!");
		}
		if(id == 2){
			return BaseResponse.errorMsg("角色不允许删除!");
		}
		SysRole role = roleMapper.selectById(id);
		if (role == null) {
			return BaseResponse.errorMsg("角色不存在!");
		}
		Integer conunts = roleMapper.getUserByRoleId(id);
		if (conunts != 0 && conunts > 0) {
			return BaseResponse.errorMsg(conunts + "个用户正在使用!");
		}
		roleMapper.deleteById(id);
		return BaseResponse.okData("删除成功");
	}

}
