package cn.wise.sc.cement.business.service.impl;

import cn.wise.sc.cement.business.entity.SysUser;
import cn.wise.sc.cement.business.entity.SysUserMessage;
import cn.wise.sc.cement.business.mapper.SysUserMessageMapper;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.LoginUser;
import cn.wise.sc.cement.business.model.Message;
import cn.wise.sc.cement.business.service.ISysUserMessageService;
import cn.wise.sc.cement.business.service.ISysUserService;
import cn.wise.sc.cement.business.util.WebSocketServer;
import cn.wise.sc.cement.business.wrapper.WrapMapper;
import cn.wise.sc.cement.business.wrapper.Wrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author ztw
 * @since 2020-10-13
 */
@Service
public class SysUserMessageServiceImpl extends ServiceImpl<SysUserMessageMapper, SysUserMessage> implements ISysUserMessageService {

	@Resource
	private SysUserMessageMapper userMessageMapper;
	@Resource
	protected HttpServletResponse response;
	@Autowired
	protected HttpServletRequest request;
	@Autowired
	WebSocketServer webSocketServer;
	@Autowired
	private ISysUserService userService;

	/**
	 * 发送消息
	 *
	 * @param userId
	 * @param message
	 * @param appId
	 * @param messageType
	 * @return
	 */
	@Override
	public BaseResponse<String> sendMessage(Integer userId, String message, Integer appId, Integer messageType) {
		int ret = 0;
		SysUserMessage userMessage = new SysUserMessage();
		userMessage.setUserId(userId);
		userMessage.setMessage(message);
		userMessage.setAppId(appId);
		userMessage.setIsCheck(0);
		userMessage.setMessageType(messageType);
		userMessage.setCreateTime(LocalDateTime.now());
		userMessage.setUpdateTime(userMessage.getCreateTime());
		userMessage.setIsDeal(0);
		ret = this.userMessageMapper.insert(userMessage);
		if (ret == 0) {
			return BaseResponse.errorMsg("消息推送失败");
		}
		String dealer = String.valueOf(userId);
		Message m = Message.builder().userId(dealer).message(message).messageType(messageType).appId(appId)
				.createTime(userMessage.getCreateTime()).build();
		webSocketServer.sendTo(m);
		/*SysUser sysUser = userService.getById(userId);
		if(sysUser != null && StringUtils.isNotBlank(sysUser.getPhone())){
			SMSUtil.sendCode(sysUser.getPhone(), message);
		}*/
		return BaseResponse.okData("成功");
	}

	/**
	 * 查看消息
	 *
	 * @param userId
	 * @param appId
	 * @param messageType
	 * @return
	 */
	@Override
	public BaseResponse<String> checkMessage(Integer userId, Integer appId, Integer messageType) {

		int ret = 0;
		List<SysUserMessage> list = this.userMessageMapper.getNoCheck(userId, appId, messageType);
		if (list != null && list.size() > 0) {
			for (SysUserMessage um : list) {
				um.setIsCheck(1);
				ret = this.userMessageMapper.updateById(um);
				if (ret == 0) {
					return BaseResponse.errorMsg("查看消息记录更新失败");
				}
			}
		}
		return BaseResponse.okData("成功");

	}

	/**
	 * 处理消息
	 *
	 * @param userId
	 * @param appId
	 * @param messageType
	 * @return
	 */
	@Override
	public BaseResponse<String> dealMessage(Integer userId, Integer appId, Integer messageType) {
		int ret = 0;
		List<SysUserMessage> list = this.userMessageMapper.getNoDeal(userId, appId, messageType);
		if (list != null && list.size() > 0) {
			for (SysUserMessage um : list) {
				um.setIsCheck(1);
				um.setIsDeal(1);
				ret = this.userMessageMapper.updateById(um);
				if (ret == 0) {
					return BaseResponse.errorMsg("处理消息记录更新失败");
				}
			}
		}
		return BaseResponse.okData("成功");
	}

	/**
	 * 消息列表
	 *
	 * @return
	 */
	@Override
	public BaseResponse<List<SysUserMessage>> getMessages() {
		LoginUser loginUser = userService.getLoginUser();
		if (loginUser == null) {
			return BaseResponse.errorMsg("请登录账号");
		}
		List<SysUserMessage> list = this.userMessageMapper.getNoDeal(loginUser.getId(), null, null);
		return BaseResponse.okData(list);
	}

}
