package cn.wise.sc.cement.business.util;

import java.time.LocalDateTime;
import java.time.temporal.WeekFields;
import java.util.Date;

/**
 * @author neo.shu
 * @since 2020/4/5 22:26
 */

public class DateUtil {

    /**
     * 获取自然周数
     *
     * @param localDateTime
     * @return
     */
    public static int getWeek(LocalDateTime localDateTime) {
        WeekFields weekFields = WeekFields.ISO;
        return localDateTime.get(weekFields.weekOfWeekBasedYear());
    }

    /**
     * 获取开始时间
     *
     * @param type 类型 1:本周 2:本月 3:本年
     * @return 开始时间
     */
    public static Date getStartTime(Integer type) {

        Date rts = null;

        if (type == 1) {
            rts = cn.hutool.core.date.DateUtil.beginOfWeek(cn.hutool.core.date.DateUtil.date());
        } else if (type == 2) {
            rts = cn.hutool.core.date.DateUtil.beginOfMonth(cn.hutool.core.date.DateUtil.date());
        } else {
            rts = cn.hutool.core.date.DateUtil.beginOfYear(cn.hutool.core.date.DateUtil.date());
        }

        return rts;
    }
}
