package cn.wise.sc.cement.business.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

import javax.servlet.http.HttpServletResponse;

import cn.afterturn.easypoi.excel.annotation.Excel;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.*;
import org.apache.poi.wp.usermodel.Paragraph;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

/**
 * excel工具类
 *
 * @author zhutianwei
 */
public class ExcelUtil {

    public static void excelLocal(String path, String fileName, String[] headers, List<Object[]> datas) {
        Workbook workbook = getWorkbook(headers, datas);
        if (workbook != null) {
            ByteArrayOutputStream byteArrayOutputStream = null;
            FileOutputStream fileOutputStream = null;
            try {
                byteArrayOutputStream = new ByteArrayOutputStream();
                workbook.write(byteArrayOutputStream);

                String suffix = ".xls";
                File file = new File(path + File.separator + fileName + suffix);
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }

                fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(byteArrayOutputStream.toByteArray());
            } catch (Exception e) {
                e.printStackTrace();
            } finally {
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                } catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    if (byteArrayOutputStream != null) {
                        byteArrayOutputStream.close();
                    }
                } catch (IOException e) {
                    e.printStackTrace();
                }

                try {
                    workbook.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /**
     * 导出excel
     *
     * @param fileName
     * @param headers
     * @param datas
     * @param response
     */
    public static void excelExport(String fileName, String[] headers, List<Object[]> datas,
                                   HttpServletResponse response) {
        Workbook workbook = getWorkbook(headers, datas);
        if (workbook != null) {
            ByteArrayOutputStream byteArrayOutputStream = null;
            try {
                byteArrayOutputStream = new ByteArrayOutputStream();
                workbook.write(byteArrayOutputStream);

                String suffix = ".xls";
                response.setContentType("application/vnd.ms-excel;charset=utf-8");
                response.setHeader("Content-Disposition",
                        "attachment;filename=" + new String((fileName + suffix).getBytes(), "iso-8859-1"));

                OutputStream outputStream = response.getOutputStream();
                outputStream.write(byteArrayOutputStream.toByteArray());
                outputStream.close();
            } catch (Exception e) {
                e.printStackTrace();
            } finally {
                try {
                    if (byteArrayOutputStream != null) {
                        byteArrayOutputStream.close();
                    }
                } catch (IOException e) {
                    e.printStackTrace();
                }

                try {
                    workbook.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void excelExportNew(String fileName, String[] headers, List<Object[]> datas,
                                      HttpServletResponse response) {
        Workbook workbook = getWorkbookNew(headers, datas);
        if (workbook != null) {
            ByteArrayOutputStream byteArrayOutputStream = null;
            try {
                byteArrayOutputStream = new ByteArrayOutputStream();
                workbook.write(byteArrayOutputStream);

                String suffix = ".xls";
                response.setContentType("application/vnd.ms-excel;charset=utf-8");
                response.setHeader("Content-Disposition",
                        "attachment;filename=" + new String((fileName + suffix).getBytes(), "iso-8859-1"));

                OutputStream outputStream = response.getOutputStream();
                outputStream.write(byteArrayOutputStream.toByteArray());
                outputStream.close();
            } catch (Exception e) {
                e.printStackTrace();
            } finally {
                try {
                    if (byteArrayOutputStream != null) {
                        byteArrayOutputStream.close();
                    }
                } catch (IOException e) {
                    e.printStackTrace();
                }

                try {
                    workbook.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /**
     * @param headers 列头
     * @param datas   数据
     * @return
     */
    public static Workbook getWorkbook(String[] headers, List<Object[]> datas) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet();

        Row row = null;
        Cell cell = null;
        XSSFFont font = workbook.createFont();
        int line = 0, maxColumn = 0;
        if (headers != null && headers.length > 0) { // 设置列头
            CellStyle style = workbook.createCellStyle();
            style.setAlignment(HorizontalAlignment.CENTER_SELECTION);

            row = sheet.createRow(line++);
            row.setHeightInPoints(23);
            font.setBold(true);
            font.setFontHeightInPoints((short) 13);
            style.setFont(font);

            maxColumn = headers.length;
            for (int i = 0; i < maxColumn; i++) {
                cell = row.createCell(i);
                cell.setCellValue(headers[i]);
                cell.setCellStyle(style);
            }
        }

        if (datas != null && datas.size() > 0) {// 渲染数据
            CellStyle style = workbook.createCellStyle();
            XSSFFont xxsfFont = workbook.createFont();

            for (int index = 0, size = datas.size(); index < size; index++) {
                Object[] data = datas.get(index);
                if (data != null && data.length > 0) {
                    row = sheet.createRow(line++);
                    row.setHeightInPoints(20);

                    int length = data.length;
                    if (length > maxColumn) {
                        maxColumn = length;
                    }

                    for (int i = 0; i < length; i++) {
                        String value = data[i] == null ? null : data[i].toString();
                        cell = row.createCell(i);
                        if (value != null) {
                            //处理下标
                            if (value.contains("<sub>") || value.contains("</sub>")) {
                                xxsfFont.setTypeOffset(FontFormatting.SS_SUB);
                                cell.setCellStyle(style);
                                XSSFRichTextString richString = new XSSFRichTextString(value.replaceAll("</sub>", "<sub>").replaceAll("<sub>", ""));
                                //提取下标位置
                                applyRichStringFontsub(value, richString, xxsfFont);
                                cell.setCellValue(richString);
                            } else if (value.contains("<sup>") || value.contains("</sup>")) {
                                xxsfFont.setTypeOffset(FontFormatting.SS_SUPER);
                                cell.setCellStyle(style);
                                XSSFRichTextString richString = new XSSFRichTextString(value.replaceAll("</sup>", "<sup>").replaceAll("<sup>", ""));
                                //提取下标位置
                                applyRichStringFontsup(value, richString, xxsfFont);
                                cell.setCellValue(richString);
                            } else {
                                cell.setCellValue(value);

                                cell.setCellStyle(style);
                            }
                        }
                    }
                }
            }
        }

        for (int i = 0; i < maxColumn; i++) {
            sheet.autoSizeColumn(i);
        }

        return workbook;
    }

    private static void applyRichStringFontsub(String sub, XSSFRichTextString richString, XSSFFont xxsfFont) {
        String[] split = sub.replaceAll("</sub>", "<sub>").split("<sub>");
        String it_str = "";
        for (int i = 1; i < split.length + 1; i++) {
            if (i % 2 != 0) {
                it_str = it_str + split[i - 1];
            } else {
                richString.applyFont(it_str.length(), (it_str + split[i - 1]).length(), xxsfFont);
                it_str = it_str + split[i - 1];
            }

        }
    }

    private static void applyRichStringFontsup(String sup, XSSFRichTextString richString, XSSFFont xxsfFont) {
        String[] split = sup.replaceAll("</sup>", "<sup>").split("<sup>");
        String it_str = "";
        for (int i = 1; i < split.length + 1; i++) {
            if (i % 2 != 0) {
                it_str = it_str + split[i - 1];
            } else {
                richString.applyFont(it_str.length(), (it_str + split[i - 1]).length(), xxsfFont);
                it_str = it_str + split[i - 1];
            }

        }
    }


    public static Workbook getWorkbookNew(String[] headers, List<Object[]> datas) {
        Workbook workbook = new HSSFWorkbook();
        Sheet sheet = workbook.createSheet();
        workbook.setSheetName(0, "样品处置记录");

        Row row = null;
        Cell cell = null;

        Font font = workbook.createFont();

        int line = 0, maxColumn = 0;
        if (headers != null && headers.length > 0) { // 设置列头
            CellStyle style = workbook.createCellStyle();
            style.setAlignment(HorizontalAlignment.CENTER_SELECTION);
            style.setVerticalAlignment(VerticalAlignment.CENTER);
            row = sheet.createRow(line++);
            row.setHeightInPoints(23);
            font.setFontHeightInPoints((short) 12);
            font.setFontName("宋体");
            style.setFont(font);

            maxColumn = headers.length;
            for (int i = 0; i < maxColumn; i++) {
                cell = row.createCell(i);
                cell.setCellValue(headers[i]);
                cell.setCellStyle(style);
            }
        }

        if (datas != null && datas.size() > 0) {// 渲染数据
            CellStyle style = workbook.createCellStyle();
            for (int index = 0, size = datas.size(); index < size; index++) {
                Object[] data = datas.get(index);
                if (data != null && data.length > 0) {
                    row = sheet.createRow(line++);
                    row.setHeightInPoints(20);

                    int length = data.length;
                    if (length > maxColumn) {
                        maxColumn = length;
                    }

                    for (int i = 0; i < length; i++) {
                        style.setWrapText(true);  //关键
                        style.setFont(font);
                        cell = row.createCell(i);
                        cell.setCellValue(data[i] == null ? null : data[i].toString());
                        cell.setCellStyle(style);
                        style.setAlignment(HorizontalAlignment.CENTER_SELECTION);
                    }
                }
            }
        }

        for (int i = 0; i < maxColumn; i++) {
            sheet.autoSizeColumn(i);
        }

        return workbook;
    }
}
