package cn.wise.sc.cement.business.util;

import cn.hutool.core.collection.CollectionUtil;
import cn.wise.sc.cement.business.model.PageQuery;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.List;

/**
 * @description:
 * @author: qh
 * @create: 2020-09-27 18:19
 **/
public class PageUtil {

	public static <T> Page<T> listConvertToPage(List<T> list, PageQuery pageQuery) {
		if (CollectionUtil.isEmpty(list)){
			return new Page<>();
		}
		int start = pageQuery.getPageNo() > 0 ? pageQuery.getPageNo() : 1;
		int pageSize = pageQuery.getPageSize() > 0 ? pageQuery.getPageSize() : 10;
		int end = Math.min((start * pageSize), list.size());
		long pageStart = (start - 1) * pageSize;
		Page<T> page = new Page<>(start, pageSize, list.size());
		if (pageStart >= list.size()) {
			return page;
		}

		page.setRecords(list.subList((int) (pageStart), end));
		return page;
	}
}
