package com.testor.common.translation.impl;

import com.testor.biz.sys.dict.data.model.domain.SysDictData;
import com.testor.common.annotation.TranslationType;
import com.testor.common.constant.TransConstant;
import com.testor.common.translation.TranslationInterface;
import com.testor.module.sys.service.NewSysDictDataService;
import lombok.AllArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

/**
 * 字典翻译实现
 *
 * @author Lion Li
 */
@Component
@AllArgsConstructor
@TranslationType(type = TransConstant.DICT_TYPE_TO_LABEL)
public class DictTypeTranslationImpl implements TranslationInterface<String> {

    private final NewSysDictDataService newSysDictDataService;

    @Override
    public String translation(Object key, String other) {
        if (key instanceof String && StringUtils.isNotBlank(other)) {
            SysDictData dictTypeDetail = newSysDictDataService.getDictTypeDetail(null, other, key.toString());
            if (dictTypeDetail != null) {
                return dictTypeDetail.getDictValue();
            }
        }
        return null;
    }
}
