package com.testor.ddd.safetyControl.infrastructure.repository.riskSource.entity;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.baomidou.mybatisplus.annotation.TableName;
import org.springframework.format.annotation.DateTimeFormat;


/**
 * 危险源对象 t_safe_risk_source_record
 * 
 * @author testor-framework
 * @date 2022-10-11 10:57:32
 */
@Data
@Accessors(chain = true)
@TableName("t_safe_risk_source_record")
@ApiModel(value = "TSafeRiskSourceRecord对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TSafeRiskSourceRecordDO implements Serializable
{
    private static final long serialVersionUID = 1L;
/**
 * id
 */
  @ApiModelProperty(value = "id")

  @TableId(value = "id",type = IdType.ASSIGN_UUID)
  private String id;
/**
 * 修改人所属组织机构id
 */
  @ApiModelProperty(value = "修改人所属组织机构id")

  @TableField("org_id")
  private String orgId;
/**
 * 修改人id
 */
  @ApiModelProperty(value = "修改人id")

  @TableField("user_id")
  private String userId;
/**
 * 危险源名称
 */
  @ApiModelProperty(value = "危险源名称")

  @TableField("name")
  private String name;
/**
 * 操作类型(1-新增；2-修改；3-删除)
 */
  @ApiModelProperty(value = "操作类型(1-新增；2-修改；3-删除)" , example = "0")

  @TableField("operate_type")
  private Integer operateType;
/**
 * 危险源idid
 */
  @ApiModelProperty(value = "危险源idid")
  @TableField("source_id")
  private String sourceId;

  @ApiModelProperty("创建时间")
  @TableField(
          value = "create_date",
          fill = FieldFill.INSERT
  )
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createDate;

  @ApiModelProperty("备注")
  @TableField("remarks")
  private String remarks;

  public static final String ID ="id";
  public static final String ORG_ID ="org_id";
  public static final String USER_ID ="user_id";
  public static final String NAME ="name";
  public static final String OPERATE_TYPE ="operate_type";
  public static final String SOURCE_ID ="source_id";


}
