package com.testor.module.contractor.ledger.controller;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import com.testor.common.excel.ExcelResult;
import com.testor.common.util.BeanConverUtil;
import com.testor.common.util.excel.EasyExcelUtil;
import com.testor.module.contractor.ledger.model.template.ProjectTemplate;
import com.testor.module.contractor.ledger.service.TContractorInfoService;
import com.testor.module.sys.service.NewSysOrgService;
import com.tongtech.tfw.backend.common.context.ContextUtils;
import com.tongtech.tfw.backend.common.models.sys.UserInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import lombok.extern.slf4j.Slf4j;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;

import com.testor.module.contractor.ledger.model.domain.TContractorProject;
import com.testor.module.contractor.ledger.model.dto.TContractorProjectParam;
import com.testor.module.contractor.ledger.model.dto.TContractorProjectDelParam;
import com.testor.module.contractor.ledger.service.TContractorProjectService;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;

/**
 * 项目台账Controller
 *
 * @author testor-framework
 * @date 2024-11-20 09:46:08
 */
@RestController
@RequestMapping("/contractor/project")
@Api(value = "TContractorProject", tags = "项目台账")
@Slf4j
public class TContractorProjectController extends SuperController
{
    @Autowired
    private TContractorProjectService tContractorProjectService;

    /* Generated Method*/
	@ApiOperation(value = "新增 项目台账", notes = "Add TContractorProject")
	@PostMapping(value = "/add")
	public BaseResponse<TContractorProject>addEntity(@RequestBody TContractorProject addRequest) {
		BaseResponse<TContractorProject> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(addRequest)){
			TContractorProject newEntity = tContractorProjectService.addEntity(addRequest);
			baseResponse.setData(newEntity);
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 项目台账 ", notes = "Get TContractorProject By Id")
	@GetMapping(value = "/get")
	public BaseResponse<TContractorProject> getById(String id){
		BaseResponse<TContractorProject> baseResponse=new BaseResponse<>();
		if(StringHelper.isNotEmpty(id)){
			// TODO 按需求添加业务异常判断
            TContractorProject data= tContractorProjectService.getById(id);
			baseResponse.setData(data);
		}
		return baseResponse;
	}

	@ApiOperation(value = "修改 项目台账 ", notes = "Update TContractorProject By Id")
	@PutMapping(value = "/update")
	public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody TContractorProject updateRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(updateRequest)&&StringHelper.isNotEmpty(updateRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TContractorProject data=BeanHelper.beanToBean(updateRequest, TContractorProject.class);
			boolean result= tContractorProjectService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "删除 项目台账 ", notes = "delete TContractorProject By Id")
	@PutMapping(value = "/delete")
	public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TContractorProjectDelParam deleteRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(deleteRequest)&&StringHelper.isNotEmpty(deleteRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TContractorProject data= new TContractorProject();
			data.setId(deleteRequest.getId());
			data.setStatus(BizConstants.STATUS_DELETE);
			boolean result= tContractorProjectService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "下载导入模板", notes = "下载导入模板")
	@GetMapping(value = "/download-template")
	public void downloadTemplate(HttpServletResponse response) {
		List<ProjectTemplate> templates = new ArrayList<>();
		templates.add(new ProjectTemplate());
		EasyExcelUtil.writeExcelBySelect(response,"导入模板","项目台账",templates);
	}

	@ApiOperation(value = "导入模板", notes = "导入模板")
	@PostMapping(value = "/import-template")
	public BaseResponse<BizGeneralResponse> importTemplate(@RequestPart("file") MultipartFile file) throws IOException {
		BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
		// 导入Excel文件，将文件流转换为ProjectTemplate对象列表
		ExcelResult<ProjectTemplate> projectTemplateExcelResult = EasyExcelUtil.importExcel(file.getInputStream(), ProjectTemplate.class, true);
		// 获取ProjectTemplate对象列表
		List<ProjectTemplate> list = projectTemplateExcelResult.getList();
		// 将ProjectTemplate对象列表转换为TContractorProject对象列表，并批量保存
		List<TContractorProject> tContractorProjects = BeanConverUtil.converList(list, TContractorProject.class);
		//tContractorProjects不为空
		if (ObjectHelper.isNotEmpty(tContractorProjects)) {
			tContractorProjects.forEach(tContractorProject -> {
				tContractorProject.setOrgId(ContextUtils.getLoginUser().getOrgId());
				tContractorProjectService.addEntity(tContractorProject);
			});
		}
		baseResponse.setMsg("导入成功");
		return baseResponse;
	}

	@ApiOperation(value = "导出项目台账", notes = "导出项目台账")
	@GetMapping(value = "/exportProjectLedger")
	public void exportProjectLedger(HttpServletResponse response,TContractorProjectParam param) {
		BaseResponse<BaseResponseList<TContractorProject>> baseResponseListBaseResponse = listAllEntity(param);
		List<TContractorProject> data = baseResponseListBaseResponse.getData().getData();
		List<ProjectTemplate> templates = new ArrayList<>(BeanConverUtil.converList(data, ProjectTemplate.class));
		if (templates.isEmpty()){
           templates.add(new ProjectTemplate());
        }
		EasyExcelUtil.writeExcelBySelect(response, "项目台账", "项目台账", templates);
	}


	@ApiOperation(value = "批量删除项目台账", notes = "delete TContractorProject by batch Id")
	@PutMapping(value = "/batch_delete")
	public BaseResponse<BizGeneralResponse> deleteEntityBatch(
			@RequestBody TContractorProjectDelParam deleteRequest) {
		BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
		if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
			List<TContractorProject> tContractorProjectList = new ArrayList<>();
            for(String id: deleteRequest.getIds()){
                TContractorProject data= new TContractorProject();
				data.setId(id);
				data.setStatus(BizConstants.STATUS_DELETE);
                tContractorProjectList.add(data);
			}
			boolean result = tContractorProjectService.updateBatchById(tContractorProjectList);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 项目台账 分页列表", notes = "List TContractorProject with page")
	@GetMapping(value = "/list")
	public  BaseResponse<BaseResponseList<TContractorProject>>listEntity(TContractorProjectParam param){
		BaseResponse<BaseResponseList<TContractorProject>>baseResponse=new BaseResponse<>();

		Page<TContractorProject> resultList= tContractorProjectService.pageList(param);
		BaseResponseList<TContractorProject> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList.getRecords());
		baseResponseList.setTotal(resultList.getTotal());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 项目台账 列表", notes = "List TContractorProject all")
	@GetMapping(value = "/datas")
	public  BaseResponse<BaseResponseList<TContractorProject>>listAllEntity(TContractorProjectParam param){
		BaseResponse<BaseResponseList<TContractorProject>>baseResponse=new BaseResponse<>();
		// TODO 根据需求修改查询条件及查询参数
		List<TContractorProject> resultList=tContractorProjectService.listAllEntity(param);
		BaseResponseList<TContractorProject> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList);
		baseResponseList.setTotal(resultList.size());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

}
