package com.testor.module.hazard.service.impl;

import com.testor.biz.sys.dict.data.model.domain.SysDictData;
import com.testor.module.hazard.model.domain.THazardWorkPlan;
import com.testor.module.hazard.service.THazardWorkPlanService;
import com.testor.module.messageNotice.model.domain.TMsgNotice;
import com.testor.module.messageNotice.model.vo.MsgTemplateVO;
import com.testor.module.messageNotice.service.TMsgNoticeService;
import com.testor.module.sys.service.NewSysDictDataService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Arrays;
import java.util.List;

@Component
public class BaseReminderStrategy {

    @Autowired
    private TMsgNoticeService tMsgNoticeService;
    @Autowired
    private NewSysDictDataService sysDictDataService;

    /**
     * 封装发送通知的逻辑
     */
    public List<TMsgNotice> sendNotice(THazardWorkPlan tHazardWorkPlan, String templateTypeName, String reminderContent) {
        //构建消息
        MsgTemplateVO msgTemplateVO = new MsgTemplateVO();
        msgTemplateVO.setTemplateType("timeoutSoon");
        msgTemplateVO.setTemplateTypeName(templateTypeName);

        // 根据不同的提醒类型设置模板内容
        String workType = tHazardWorkPlan.getWorkType();
        String workLevel = tHazardWorkPlan.getWorkLevel();

        SysDictData workTypeDict = sysDictDataService.getDictTypeDetail(workType, null, null);
        SysDictData workLevelDict = sysDictDataService.getDictTypeDetail(workLevel, null, null);
        String workTypeName = workTypeDict.getDictValue();
        String workLevelName = workLevelDict.getDictValue();

        String content = "您负责的【"+tHazardWorkPlan.getWorkContent() + "-" + workTypeName + "-" + workLevelName + "】的危险作业";

        // 接收消息人员id
        String workSiteResponsible = tHazardWorkPlan.getWorkSiteResponsible().replace("0-", "");
        List<String>  userIds = Arrays.asList(workSiteResponsible.split(","));

        // 根据提醒类型动态更新提醒内容
        if ("作业即将超时".equals(templateTypeName)) {
            content += "距离作业关闭还剩【" + reminderContent + "】, 请及时处理。";
        } else if ("作业超时".equals(templateTypeName)) {
            content += "已经超时，请及时处理。";
        }

        msgTemplateVO.setTemplateContent(content);

        // 生成消息通知
        return tMsgNoticeService.generateMsgNotice("hazardousTask", tHazardWorkPlan.getId(), userIds, msgTemplateVO);
    }
}
