package com.testor.module.partner.service;


import com.testor.module.partner.model.domain.TJobStatistics;
import com.testor.module.partner.model.dto.TJobStatisticsParam;
import com.testor.module.partner.model.vo.*;
import com.tongtech.tfw.backend.common.models.supers.SuperService;

import java.util.List;

/**
 * 现场作业统计Service接口
 * 
 * @author testor-framework
 * @date 2022-11-02 10:42:06
 */
public interface TJobStatisticsService extends SuperService<TJobStatistics> {
    /**
     * 总部危险作业次数
     * @param param
     * @return
     */
    List<DangerousNumVO> dangerousNum(TJobStatisticsParam param);

    /**
     * 区域公司粮库数据统计
     *
     * @param param 参数
     * @return {@link List}<{@link DangerousNumVO}>
     */
    List<DangerousNumVO> regionalGrain(TJobStatisticsParam param);
    /**
     * 区域公司租力库数据统计
     *
     * @param param 参数
     * @return {@link List}<{@link DangerousNumVO}>
     */
    List<DangerousNumVO> area(TJobStatisticsParam param);
    /**
     * 粮库数据统计
     *
     * @param param 参数
     * @return {@link List}<{@link DangerousNumVO}>
     */
    List<DangerousNumVO> grainDepot(TJobStatisticsParam param);

    /**
     * 各类危险作业分布（总部）
     * @param param
     * @return
     */
    HazardousOperation distributionSum(TJobStatisticsParam param);

    /**
     * 各类危险作业分布(区域公司粮库)
     *
     * @param param 参数
     * @return {@link List}<{@link DangerousNumVO}>
     */
    HazardousOperation distributionRegionalCompanyGrainDepot(TJobStatisticsParam param);
    /**
     * 各类危险作业分布(区域公司租赁库)
     *
     * @param param 参数
     * @return {@link List}<{@link DangerousNumVO}>
     */
    HazardousOperation distributionRegionalCompaniesRentStorage(TJobStatisticsParam param);
    /**
     * 各类危险作业分布(粮库)
     *
     * @param param 参数
     * @return {@link List}<{@link DangerousNumVO}>
     */
    HazardousOperation distributionGrainDepot(TJobStatisticsParam param);

    /**
     * 外来作业相关方人次统计(总部)
     *
     * @param param 参数
     * @return {@link List}<{@link DangerousNumVO}>
     */
    List<DangerousNumVO> foreignHeadquarters(TJobStatisticsParam param);

    /**
     * 外来作业相关方人次统计(区域粮库)
     *
     * @param param 参数
     * @return {@link List}<{@link DangerousNumVO}>
     */
    List<DangerousNumVO> foreignRegionalGrain(TJobStatisticsParam param);

    /**
     * 外来作业相关方人次统计(租赁库)
     *
     * @param param 参数
     * @return {@link List}<{@link DangerousNumVO}>
     */
    List<DangerousNumVO> foreignRentalLibrary(TJobStatisticsParam param);


    /**
     * 外来作业相关方人次统计(粮库)
     *
     * @param param 参数
     * @return {@link List}<{@link DangerousNumVO}>
     */
    List<DangerousNumVO> foreignGrainDepot(TJobStatisticsParam param);

    /**
     * 现场作业统计表格（总部）
     *
     * @param param 参数
     * @return {@link List}<{@link FieldStatisticsFormVO}>
     */
    List<FieldStatisticsFormVO> fieldStatisticsFormHeadquarters(TJobStatisticsParam param);

    /**
     * 现场作业统计表格（区域公司租赁库）
     *
     * @param param 参数
     * @return {@link List}<{@link FieldStatisticsFormVO}>
     */
    List<FieldStatisticsFormVO> fieldStatisticsFormRegionalCorporateRentalLibrary(TJobStatisticsParam param);

    /**
     * 现场作业统计表格（区域公司粮库）
     * @param param
     * @return
     */
    List<FieldStatisticsFormVO> fieldStatisticsFormGrainDepot(TJobStatisticsParam param);
    /**
     * 现场作业统计表格（粮库）
     * @param param
     * @return
     */
    List<FieldStatisticsFormVO> fieldStatisticsFormSingle(TJobStatisticsParam param);

    /**
     * 首页危险作业总部和区域
     * @return
     */
    HazardousWorkStatisticsVo regionalStatistics(String orgId);

    /**
     * 首页危险作业（总部、区域），本日计划进行
     *
     * @return {@link Long}
     */
    Long regionalStatisticsCount(String orgId);

    void addJob();

}
