/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.workflow.apis.task.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.context.ContextUtils;
import com.tongtech.tfw.backend.common.models.exceptions.ApiException;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.common.models.sys.UserInfo;
import com.tongtech.tfw.backend.core.helper.CollectionHelper;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import com.tongtech.tfw.workflow.apis.instance.model.domain.ActHiProcinst;
import com.tongtech.tfw.workflow.apis.instance.service.ActHiProcinstService;
import com.tongtech.tfw.workflow.apis.task.TaskEnumCode;
import com.tongtech.tfw.workflow.apis.task.model.dto.ClaimTask;
import com.tongtech.tfw.workflow.apis.task.model.dto.CompleteTask;
import com.tongtech.tfw.workflow.apis.task.model.dto.HisTask;
import com.tongtech.tfw.workflow.apis.task.model.dto.HisTaskListRequest;
import com.tongtech.tfw.workflow.apis.task.model.dto.HisTaskSqlParam;
import com.tongtech.tfw.workflow.apis.task.model.dto.HisTasksRequest;
import com.tongtech.tfw.workflow.apis.task.model.dto.HisTasksResponse;
import com.tongtech.tfw.workflow.apis.task.model.dto.TodoListRequest;
import com.tongtech.tfw.workflow.apis.task.model.dto.TodoTask;
import com.tongtech.tfw.workflow.apis.task.model.dto.TodoTaskSqlParam;
import com.tongtech.tfw.workflow.apis.task.service.ActRuTaskService;
import com.tongtech.tfw.workflow.apis.user.service.ActIdUserService;
import com.tongtech.tfw.workflow.service.TfwCommonService;
import com.tongtech.tfw.workflow.service.TfwTaskService;
import com.tongtech.tfw.workflow.service.dto.TaskCompleteParams;
import com.tongtech.tfw.workflow.service.dto.TaskServiceResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.ExtensionElement;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.UserTask;
import org.flowable.engine.HistoryService;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.history.HistoricActivityInstance;
import org.flowable.engine.history.HistoricActivityInstanceQuery;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.task.api.Task;
import org.flowable.variable.api.history.HistoricVariableInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(value="Wf Task Controller", tags={"WF\u6d41\u7a0b\u4efb\u52a1\u7ba1\u7406"})
@RequestMapping(value={"/wf/task"})
public class WfTaskController
extends SuperController {
    private static final Logger log = LoggerFactory.getLogger(WfTaskController.class);
    @Autowired
    private ActRuTaskService actRuTaskService;
    @Autowired
    private TfwTaskService tfwTaskService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private ActHiProcinstService actHiProcinstService;
    @Autowired
    private ActIdUserService actIdUserService;
    @Autowired
    private TfwCommonService tfwCommonService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private RuntimeService runtimeService;

    @ApiOperation(value="\u5f85\u529e\u4efb\u52a1(\u5305\u542b\u5f85\u7b7e\u6536)", notes="\u5f85\u529e\u4efb\u52a1(\u5305\u542b\u5f85\u7b7e\u6536)")
    @GetMapping(value={"/todo/list"})
    public BaseResponse<BaseResponseList<TodoTask>> toDoTaskList(TodoListRequest todoListRequest) {
        BaseResponse baseResponse = new BaseResponse();
        BaseResponseList resultResList = new BaseResponseList();
        Long page = StringHelper.isEmpty((CharSequence)todoListRequest.getPage()) ? BizConstants.PAGE : Long.valueOf(todoListRequest.getPage());
        Long limit = StringHelper.isEmpty((CharSequence)todoListRequest.getLimit()) ? BizConstants.LIMIT : Long.valueOf(todoListRequest.getLimit());
        Page resultPage = new Page(page.longValue(), limit.longValue());
        TodoTaskSqlParam todoTaskSqlParam = new TodoTaskSqlParam();
        if (StringHelper.isNotBlank((CharSequence)todoListRequest.getUsername())) {
            todoTaskSqlParam.setUserId(todoListRequest.getUsername());
        } else {
            todoTaskSqlParam.setUserId(this.getUserId());
        }
        if (StringHelper.isNotBlank((CharSequence)todoListRequest.getStartUser())) {
            todoTaskSqlParam.setUserName(todoListRequest.getStartUser());
        }
        if (StringHelper.isNotBlank((CharSequence)todoListRequest.getProcessDefinitionName())) {
            todoTaskSqlParam.setProDefName(todoListRequest.getProcessDefinitionName());
        }
        if (StringHelper.isNotBlank((CharSequence)todoListRequest.getProcessDefinitionId())) {
            todoTaskSqlParam.setProDefId(todoListRequest.getProcessDefinitionId());
        }
        if (StringHelper.isNotBlank((CharSequence)todoListRequest.getProcessDefinitionKey())) {
            todoTaskSqlParam.setProDefKey(todoListRequest.getProcessDefinitionKey());
        }
        if (StringHelper.isNotBlank((CharSequence)todoListRequest.getOrgId())) {
            todoTaskSqlParam.setOrgId(todoListRequest.getOrgId());
        } else {
            UserInfo curUser = ContextUtils.getLoginUser();
            todoTaskSqlParam.setOrgId(curUser.getOrgId());
        }
        IPage<TodoTask> queryList = this.actRuTaskService.selectToDoList((IPage<TodoTask>)resultPage, todoTaskSqlParam);
        List resultList = queryList.getRecords();
        resultList.forEach(task -> {
            task.setAssigned(StringHelper.isBlank((CharSequence)task.getAssignee()) ? "0" : "1");
            task.setProcessInstanceSuspended(((ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult()).isSuspended());
        });
        resultResList.setData(resultList);
        resultResList.setTotal(queryList.getTotal());
        baseResponse.setData((Object)resultResList);
        return baseResponse;
    }

    @ApiOperation(value="\u5f85\u529e\u4efb\u52a1(\u4e0d\u5305\u542b\u5f85\u7b7e\u6536)", notes="\u5f85\u529e\u4efb\u52a1(\u4e0d\u5305\u542b\u5f85\u7b7e\u6536)")
    @GetMapping(value={"/todo/listConfirmed"})
    public BaseResponse<BaseResponseList<TodoTask>> toDoConfirmedTaskList(TodoListRequest todoListRequest) {
        BaseResponse baseResponse = new BaseResponse();
        BaseResponseList resultResList = new BaseResponseList();
        Long page = StringHelper.isEmpty((CharSequence)todoListRequest.getPage()) ? BizConstants.PAGE : Long.valueOf(todoListRequest.getPage());
        Long limit = StringHelper.isEmpty((CharSequence)todoListRequest.getLimit()) ? BizConstants.LIMIT : Long.valueOf(todoListRequest.getLimit());
        Page resultPage = new Page(page.longValue(), limit.longValue());
        TodoTaskSqlParam todoTaskSqlParam = new TodoTaskSqlParam();
        if (StringHelper.isNotBlank((CharSequence)todoListRequest.getUsername())) {
            todoTaskSqlParam.setUserId(todoListRequest.getUsername());
        } else {
            todoTaskSqlParam.setUserId(this.getUserId());
        }
        if (StringHelper.isNotBlank((CharSequence)todoListRequest.getStartUser())) {
            todoTaskSqlParam.setUserName(todoListRequest.getStartUser());
        }
        if (StringHelper.isNotBlank((CharSequence)todoListRequest.getProcessDefinitionName())) {
            todoTaskSqlParam.setProDefName(todoListRequest.getProcessDefinitionName());
        }
        IPage<TodoTask> queryList = this.actRuTaskService.selectToDoConfirmedTaskList((IPage<TodoTask>)resultPage, todoTaskSqlParam);
        resultResList.setData(queryList.getRecords());
        resultResList.setTotal(queryList.getTotal());
        baseResponse.setData((Object)resultResList);
        return baseResponse;
    }

    @ApiOperation(value="\u5df2\u529e\u4efb\u52a1", notes="\u5df2\u529e\u4efb\u52a1")
    @GetMapping(value={"/history/list"})
    public BaseResponse<BaseResponseList<HisTask>> hisTaskList(HisTaskListRequest hisTaskListRequest) {
        BaseResponse baseResponse = new BaseResponse();
        BaseResponseList resultResList = new BaseResponseList();
        Long page = StringHelper.isEmpty((CharSequence)hisTaskListRequest.getPage()) ? BizConstants.PAGE : Long.valueOf(hisTaskListRequest.getPage());
        Long limit = StringHelper.isEmpty((CharSequence)hisTaskListRequest.getLimit()) ? BizConstants.LIMIT : Long.valueOf(hisTaskListRequest.getLimit());
        Page resultPage = new Page(page.longValue(), limit.longValue());
        HisTaskSqlParam hisTaskSqlParam = new HisTaskSqlParam();
        if (StringHelper.isNotBlank((CharSequence)hisTaskListRequest.getUsername())) {
            hisTaskSqlParam.setUserId(hisTaskListRequest.getUsername());
        } else {
            hisTaskSqlParam.setUserId(this.getUserId());
        }
        if (StringHelper.isNotBlank((CharSequence)hisTaskListRequest.getStartUser())) {
            hisTaskSqlParam.setUserName(hisTaskListRequest.getStartUser());
        }
        if (StringHelper.isNotBlank((CharSequence)hisTaskListRequest.getProcessDefinitionName())) {
            hisTaskSqlParam.setProDefName(hisTaskListRequest.getProcessDefinitionName());
        }
        IPage<HisTask> queryList = this.actRuTaskService.selectHisTaskList((IPage<HisTask>)resultPage, hisTaskSqlParam);
        resultResList.setData(queryList.getRecords());
        resultResList.setTotal(queryList.getTotal());
        baseResponse.setData((Object)resultResList);
        return baseResponse;
    }

    @ApiOperation(value="\u7b7e\u6536\u4efb\u52a1", notes="\u7b7e\u6536\u4efb\u52a1")
    @PostMapping(value={"/claim"})
    public BaseResponse<BizGeneralResponse> claimTask(@RequestBody @Valid ClaimTask claimTask) {
        BaseResponse baseResponse = new BaseResponse();
        if (StringHelper.isBlank((CharSequence)claimTask.getUserId())) {
            claimTask.setUserId(this.getUserId());
        }
        try {
            TaskServiceResult taskServiceResult = this.tfwTaskService.claimTask(claimTask.getTaskId(), claimTask.getUserId());
            baseResponse.setData((Object)BizGeneralResponse.builder().result(taskServiceResult.getCode()).build());
            return baseResponse;
        }
        catch (Exception var4) {
            log.error("\u7b7e\u6536\u4efb\u52a1 ERROR: " + var4);
            throw new ApiException(TaskEnumCode.CLAIM_FAILED.transform());
        }
    }

    @ApiOperation(value="\u5b8c\u6210\u4efb\u52a1", notes="\u5b8c\u6210\u4efb\u52a1")
    @PostMapping(value={"/complete"})
    public BaseResponse<BizGeneralResponse> completeTask(@RequestBody @Valid CompleteTask completeTask) {
        BaseResponse baseResponse = new BaseResponse();
        if (StringHelper.isBlank((CharSequence)completeTask.getUserId())) {
            completeTask.setUserId(this.getUserId());
        }
        if (StringHelper.isBlank((CharSequence)completeTask.getOrgId())) {
            UserInfo curUser = ContextUtils.getLoginUser();
            completeTask.setOrgId(curUser.getOrgId());
        }
        if (StringHelper.isBlank((CharSequence)completeTask.getBizId())) {
            completeTask.setBizId(IdHelper.getId32bitTime());
        }
        try {
            TaskCompleteParams taskCompleteParams = (TaskCompleteParams)BeanHelper.beanToBean((Object)completeTask, TaskCompleteParams.class);
            TaskServiceResult taskServiceResult = this.tfwTaskService.completeTask(taskCompleteParams);
            baseResponse.setData((Object)BizGeneralResponse.builder().result(taskServiceResult.getCode()).build());
            return baseResponse;
        }
        catch (Exception var5) {
            log.error("\u5b8c\u6210\u4efb\u52a1 ERROR: " + var5);
            throw new ApiException(TaskEnumCode.COMPLETE_FAILED.transform());
        }
    }

    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u5b9e\u4f8bID\u83b7\u53d6\u4efb\u52a1\u5386\u53f2", notes="\u6839\u636e\u6d41\u7a0b\u5b9e\u4f8bID\u83b7\u53d6\u4efb\u52a1\u5386\u53f2")
    @GetMapping(value={"/getHistoryByInstanceId"})
    public BaseResponse<BaseResponseList<HisTasksResponse>> getHistoryByInstanceId(HisTasksRequest hisTasksRequest) {
        BaseResponse baseResponse = new BaseResponse();
        BaseResponseList resultResList = new BaseResponseList();
        HashSet<String> types = new HashSet<String>();
        types.add("userTask");
        types.add("startEvent");
        List activityInstanceList = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(hisTasksRequest.getProcessInstanceId()).activityTypes(types).orderByHistoricActivityInstanceStartTime().asc()).list();
        ArrayList<HisTasksResponse> resultData = new ArrayList<HisTasksResponse>();
        for (HistoricActivityInstance historicActivityInstance : activityInstanceList) {
            HisTasksResponse hisTasksResponse = new HisTasksResponse(historicActivityInstance);
            if (StringHelper.isNotBlank((CharSequence)hisTasksResponse.getUser())) {
                hisTasksResponse.setUser(this.tfwCommonService.queryUserName(hisTasksResponse.getUser()));
            } else if ("startEvent".equals(hisTasksResponse.getTaskType())) {
                String startUser = ((ActHiProcinst)this.actHiProcinstService.getOne((Wrapper)new QueryWrapper().eq((Object)"PROC_INST_ID_", (Object)historicActivityInstance.getProcessInstanceId()))).getStartUserId();
                hisTasksResponse.setUser(this.tfwCommonService.queryUserName(startUser));
            }
            if (StringHelper.isNotBlank((CharSequence)hisTasksResponse.getTaskId())) {
                try {
                    List taskVarList = this.historyService.createHistoricVariableInstanceQuery().taskId(hisTasksResponse.getTaskId()).list();
                    if (!taskVarList.isEmpty()) {
                        Map<String, Object> var = taskVarList.stream().collect(Collectors.toMap(HistoricVariableInstance::getVariableName, e -> e.getValue() == null ? "" : e.getValue(), (k1, k2) -> k1));
                        hisTasksResponse.setVars(var);
                    }
                }
                catch (Exception e2) {
                    log.error(e2.toString());
                }
            }
            resultData.add(hisTasksResponse);
        }
        resultResList.setData(resultData);
        resultResList.setTotal((long)resultData.size());
        baseResponse.setData((Object)resultResList);
        return baseResponse;
    }

    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u5b9e\u4f8bID\u548c\u4efb\u52a1ID\u83b7\u53d6\u5355\u4e2a\u4efb\u52a1\u5386\u53f2", notes="\u6839\u636e\u6d41\u7a0b\u5b9e\u4f8bID\u548c\u4efb\u52a1ID\u83b7\u53d6\u5355\u4e2a\u4efb\u52a1\u5386\u53f2")
    @GetMapping(value={"/getSingleHistoryByInstanceIdAndTaskId"})
    public BaseResponse<HisTasksResponse> getSingleHistoryByInstanceIdAndTaskId(@RequestParam(value="processInstanceId") String processInstanceId, @RequestParam(value="taskId") String taskId) {
        BaseResponse baseResponse = new BaseResponse();
        HisTasksResponse hisTasksResponse = null;
        for (HistoricActivityInstance historicActivityInstance : ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).orderByHistoricActivityInstanceStartTime().asc()).list()) {
            List taskVarList;
            if (!taskId.equals(historicActivityInstance.getTaskId())) continue;
            hisTasksResponse = new HisTasksResponse(historicActivityInstance);
            if (StringHelper.isNotBlank((CharSequence)hisTasksResponse.getUser())) {
                hisTasksResponse.setUser(this.tfwCommonService.queryUserName(hisTasksResponse.getUser()));
            } else if ("startEvent".equals(hisTasksResponse.getTaskType())) {
                String startUser = ((ActHiProcinst)this.actHiProcinstService.getOne((Wrapper)new QueryWrapper().eq((Object)"PROC_INST_ID_", (Object)historicActivityInstance.getProcessInstanceId()))).getStartUserId();
                hisTasksResponse.setUser(this.tfwCommonService.queryUserName(startUser));
            }
            if (!StringHelper.isNotBlank((CharSequence)hisTasksResponse.getTaskId()) || (taskVarList = this.historyService.createHistoricVariableInstanceQuery().taskId(hisTasksResponse.getTaskId()).list()).isEmpty()) break;
            Map<String, Object> var = taskVarList.stream().collect(Collectors.toMap(HistoricVariableInstance::getVariableName, e -> e.getValue() == null ? "" : e.getValue(), (k1, k2) -> k1));
            hisTasksResponse.setVars(var);
            break;
        }
        if (hisTasksResponse != null) {
            baseResponse.setData(hisTasksResponse);
        } else {
            baseResponse.setCode(Integer.valueOf(404));
            baseResponse.setMsg("\u672a\u627e\u5230\u76f8\u5173\u4efb\u52a1\u5386\u53f2\u8bb0\u5f55");
        }
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6 pros \u5217\u8868", notes="List WfHoliday all")
    @GetMapping(value={"/props"})
    public BaseResponse<Map<String, String>> getCustomProperty(String taskId, String propertyName) {
        Map customProperties;
        BaseResponse baseResponse = new BaseResponse();
        HashMap<String, String> resultMap = new HashMap<String, String>(1);
        Task task = this.tfwTaskService.getRuTask(taskId);
        if (ObjectHelper.isEmpty((Object)task)) {
            throw new ApiException(TaskEnumCode.TASK_NOT_FOUND.transform());
        }
        FlowElement flowElement = null;
        for (HistoricActivityInstance act : this.historyService.createHistoricActivityInstanceQuery().executionId(task.getExecutionId()).list()) {
            if (!StringHelper.isNotEmpty((CharSequence)act.getTaskId()) || !act.getTaskId().equalsIgnoreCase(taskId)) continue;
            flowElement = this.getFlowElementByActivityIdAndProcessDefinitionId(act.getActivityId(), act.getProcessDefinitionId());
            break;
        }
        if (ObjectHelper.isNotEmpty(flowElement) && flowElement instanceof UserTask && ObjectHelper.isNotEmpty((Object)(customProperties = flowElement.getExtensionElements()))) {
            ExtensionElement extensionElement;
            List extensionElements = (List)customProperties.get(propertyName);
            if (CollectionHelper.isNotEmpty((Collection)extensionElements) && ObjectHelper.isNotEmpty((Object)(extensionElement = (ExtensionElement)extensionElements.get(0)))) {
                String value = (String)ObjectHelper.defaultIfNull((Object)extensionElement.getElementText(), (Object)"");
                resultMap.put(propertyName, value);
            }
            baseResponse.setData(resultMap);
        }
        return baseResponse;
    }

    private FlowElement getFlowElementByActivityIdAndProcessDefinitionId(String activityId, String processDefinitionId) {
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitionId);
        List processes = bpmnModel.getProcesses();
        if (CollectionHelper.isNotEmpty((Collection)processes)) {
            for (Process process : processes) {
                FlowElement flowElement = process.getFlowElement(activityId);
                if (!ObjectHelper.isNotEmpty((Object)flowElement)) continue;
                return flowElement;
            }
        }
        return null;
    }

    @ApiOperation(value="\u7edf\u8ba1\u7528\u6237 \u6bcf\u4e2a\u6d41\u7a0b\u5b9a\u4e49\u4e2d \u672a\u5904\u7406\u7684\u4e2a\u6570", notes="\u7edf\u8ba1\u7528\u6237 \u6bcf\u4e2a\u6d41\u7a0b\u5b9a\u4e49\u4e2d \u672a\u5904\u7406\u7684\u4e2a\u6570")
    @GetMapping(value={"/todo/countToDo"})
    public BaseResponse<List<Map>> countToDo() {
        BaseResponse baseResponse = new BaseResponse();
        UserInfo userInfo = ContextUtils.getLoginUser();
        List<Map> countList = this.actRuTaskService.countToDo(userInfo.getUserId(), userInfo.getOrgId());
        baseResponse.setData(countList);
        return baseResponse;
    }
}

