

# 20250430上线修改

# 数据库变更
# 许可证修改备注字段为 text类型
ALTER TABLE t_hazard_license
ALTER COLUMN remarks TYPE TEXT;

# 添加许可证表字段
ALTER TABLE t_hazard_license ADD COLUMN power_unit_signature TEXT;

# 安全条件确认明细表condition字段扩充
ALTER TABLE t_hazard_condition_confirmation_details
ALTER COLUMN condition TYPE varchar(2000);

# 危险作业计划监督检查
--  DROP TABLE `t_hazard_work_plan_check`;
CREATE TABLE "t_hazard_work_plan_check" (
"id" varchar(255) NOT NULL,
"plan_id" varchar(255) NULL,
"check_time" timestamp NULL,
"is_compliant" varchar(255) NULL,
"problem_type" varchar(255) NULL,
"check_description" text NULL,
"check_images" text NULL,
"check_signature" varchar(255) NULL,
"status" varchar(255) NULL DEFAULT '0',
"create_by" varchar(255) NULL,
"create_date" timestamp NULL DEFAULT CURRENT_TIMESTAMP,
"update_by" varchar(255) NULL,
"update_date" timestamp NULL DEFAULT CURRENT_TIMESTAMP,
"remarks" varchar(255) NULL,
"check_unit" varchar(255) NULL,
"basic_unit" varchar(255) NULL,
"check_status" varchar(255) NULL,
"check_signature_time" timestamp NULL,
"check_name" varchar(255) NULL,
"check_id" varchar(255) NULL,
"basic_id" varchar(255) NULL,
CONSTRAINT "PRIMARY_BFFDA859" PRIMARY KEY ("id")
);

COMMENT ON TABLE t_hazard_work_plan_check IS '危险作业计划监督检查';
COMMENT ON COLUMN t_hazard_work_plan_check.plan_id IS '危险作业计划id';
COMMENT ON COLUMN t_hazard_work_plan_check.check_time IS '检查时间';
COMMENT ON COLUMN t_hazard_work_plan_check.is_compliant IS '是否合规 0否 1是';
COMMENT ON COLUMN t_hazard_work_plan_check.problem_type IS '问题类别 字典id';
COMMENT ON COLUMN t_hazard_work_plan_check.check_description IS '问题描述';
COMMENT ON COLUMN t_hazard_work_plan_check.check_images IS '检查图片地址';
COMMENT ON COLUMN t_hazard_work_plan_check.check_signature IS '检查人签字';
COMMENT ON COLUMN t_hazard_work_plan_check.status IS '状态：0正常 1删除 2停用';
COMMENT ON COLUMN t_hazard_work_plan_check.create_by IS '创建者';
COMMENT ON COLUMN t_hazard_work_plan_check.create_date IS '创建时间';
COMMENT ON COLUMN t_hazard_work_plan_check.update_by IS '最后一次更新者';
COMMENT ON COLUMN t_hazard_work_plan_check.update_date IS '最后一次更新时间';
COMMENT ON COLUMN t_hazard_work_plan_check.remarks IS '备注';
COMMENT ON COLUMN t_hazard_work_plan_check.check_unit IS '检查单位';
COMMENT ON COLUMN t_hazard_work_plan_check.basic_unit IS '基层单位';
COMMENT ON COLUMN t_hazard_work_plan_check.check_id IS '检查单位id';
COMMENT ON COLUMN t_hazard_work_plan_check.basic_id IS '基层单位id';
COMMENT ON COLUMN t_hazard_work_plan_check.check_status IS '监督检查状态(1 暂存 2已完成)';
COMMENT ON COLUMN t_hazard_work_plan_check.check_signature_time IS '签字时间';
COMMENT ON COLUMN t_hazard_work_plan_check.check_name IS '检查人姓名';


INSERT INTO "t_sys_dict_type" ("dict_id", "dict_name", "dict_type", "is_sys", "status", "create_by", "create_date", "update_by", "update_date", "remarks", "parent_id", "parent_ids", "tree_sort", "cascaded") VALUES ('736049b40cb04b1fb5c2ef5385655ee3', '监督检查问题类别字典值', 'problem_type', '1', '0', '1242684364872761344', '2025-04-16 11:05:56', '1242684364872761344', '2025-04-16 11:05:56', '', NULL, NULL, NULL, '0');

INSERT INTO "public"."t_sys_dict_data" ("dict_data_id", "dict_id", "dict_key", "dict_value", "tree_sort", "status", "create_by", "create_date", "update_by", "update_date", "remarks", "parent_id", "parent_ids") VALUES ('30f8ff1dcf5f4e5bbb914861775e98c1', '736049b40cb04b1fb5c2ef5385655ee3', '1', '五必须', '1', '0', '1242684364872761344', '2025-04-16 11:09:59', '1242684364872761344', '2025-04-16 11:09:59', '', '0', '0,');
INSERT INTO "public"."t_sys_dict_data" ("dict_data_id", "dict_id", "dict_key", "dict_value", "tree_sort", "status", "create_by", "create_date", "update_by", "update_date", "remarks", "parent_id", "parent_ids") VALUES ('50af093c9d6140b4a4b00bb789040d63', '736049b40cb04b1fb5c2ef5385655ee3', '2', '信息的真实性', '2', '0', '1242684364872761344', '2025-04-16 11:10:10', '1242684364872761344', '2025-04-16 11:10:10', '', '0', '0,');
INSERT INTO "public"."t_sys_dict_data" ("dict_data_id", "dict_id", "dict_key", "dict_value", "tree_sort", "status", "create_by", "create_date", "update_by", "update_date", "remarks", "parent_id", "parent_ids") VALUES ('6e3af0c10b9d4f738f33f72b873a85d1', '736049b40cb04b1fb5c2ef5385655ee3', '3', '违章作业', '3', '0', '1242684364872761344', '2025-04-16 11:10:29', '1242684364872761344', '2025-04-16 11:10:29', '', '0', '0,');
INSERT INTO "public"."t_sys_dict_data" ("dict_data_id", "dict_id", "dict_key", "dict_value", "tree_sort", "status", "create_by", "create_date", "update_by", "update_date", "remarks", "parent_id", "parent_ids") VALUES ('35b38e370dc748a3b3eea218919722f1', '736049b40cb04b1fb5c2ef5385655ee3', '4', '劳动组织', '4', '0', '1242684364872761344', '2025-04-16 11:10:37', '1242684364872761344', '2025-04-16 11:10:37', '', '0', '0,');
INSERT INTO "public"."t_sys_dict_data" ("dict_data_id", "dict_id", "dict_key", "dict_value", "tree_sort", "status", "create_by", "create_date", "update_by", "update_date", "remarks", "parent_id", "parent_ids") VALUES ('00346c080d9246698db11036047bf496', '736049b40cb04b1fb5c2ef5385655ee3', '5', '风险管控', '5', '0', '1242684364872761344', '2025-04-16 11:10:44', '1242684364872761344', '2025-04-16 11:10:44', '', '0', '0,');
INSERT INTO "public"."t_sys_dict_data" ("dict_data_id", "dict_id", "dict_key", "dict_value", "tree_sort", "status", "create_by", "create_date", "update_by", "update_date", "remarks", "parent_id", "parent_ids") VALUES ('6ad2e5cc30734197b2e155029af99d2f', '736049b40cb04b1fb5c2ef5385655ee3', '6', '提级管理', '6', '0', '1242684364872761344', '2025-04-16 11:10:53', '1242684364872761344', '2025-04-16 11:10:53', '', '0', '0,');
INSERT INTO "public"."t_sys_dict_data" ("dict_data_id", "dict_id", "dict_key", "dict_value", "tree_sort", "status", "create_by", "create_date", "update_by", "update_date", "remarks", "parent_id", "parent_ids") VALUES ('f68a22c3889b49a3b8f939d0d87d8ebd', '736049b40cb04b1fb5c2ef5385655ee3', '7', '变更管理', '7', '0', '1242684364872761344', '2025-04-16 11:11:02', '1242684364872761344', '2025-04-16 11:11:02', '', '0', '0,');
INSERT INTO "public"."t_sys_dict_data" ("dict_data_id", "dict_id", "dict_key", "dict_value", "tree_sort", "status", "create_by", "create_date", "update_by", "update_date", "remarks", "parent_id", "parent_ids") VALUES ('421d5b5b6ef242d5a69a5e30c98291ab', '736049b40cb04b1fb5c2ef5385655ee3', '8', '视频抽查', '8', '0', '1242684364872761344', '2025-04-16 11:11:12', '1242684364872761344', '2025-04-16 11:11:12', '', '0', '0,');
INSERT INTO "public"."t_sys_dict_data" ("dict_data_id", "dict_id", "dict_key", "dict_value", "tree_sort", "status", "create_by", "create_date", "update_by", "update_date", "remarks", "parent_id", "parent_ids") VALUES ('45f5a92168e642fe8a07e62a56105ade', '736049b40cb04b1fb5c2ef5385655ee3', '9', '其他', '9', '0', '1242684364872761344', '2025-04-16 11:11:20', '1242684364872761344', '2025-04-16 11:11:20', '', '0', '0,');
INSERT INTO "public"."t_sys_dict_data" ("dict_data_id", "dict_id", "dict_key", "dict_value", "tree_sort", "status", "create_by", "create_date", "update_by", "update_date", "remarks", "parent_id", "parent_ids") VALUES ('ff4336e3feb14f5ea3ad447b676ecebd', '736049b40cb04b1fb5c2ef5385655ee3', '10', '建议', '10', '0', '1242684364872761344', '2025-04-16 11:11:27', '1242684364872761344', '2025-04-16 11:11:27', '', '0', '0,');


# 流程图

# 修改流程
hazardousTaskBLDept 流程图
安全管理部门 不为现场确认时 添加条件 ${isOnSiteConfirmation=='0'}


hazardousTaskBLOrg hazardousTaskBLDept hazardousTaskConfinedSpace  hazardousTaskBLDeptConfinedSpace 流程图
修改
安全许可证（审批)-安全分管领导
或企业主要负责人签字 

签字改为审核

# 新增流程图
hazardousTaskStifling
hazardousTaskBLLN2





# 20250430至20250516上线修改

# 添加供电单位相关负责人姓名字段
ALTER TABLE t_hazard_license ADD COLUMN power_unit_create_name VARCHAR(255);
COMMENT ON COLUMN t_hazard_license.power_unit_create_name IS '供电单位相关负责人姓名字段';

# 添加供电单位相关负责人id字段
ALTER TABLE t_hazard_license ADD COLUMN power_unit_create_by VARCHAR(255);
COMMENT ON COLUMN t_hazard_license.power_unit_create_by IS '供电单位相关负责人姓名字段';

# 添加供电单位签字(危险确认签字)字段
ALTER TABLE t_hazard_license ADD COLUMN power_unit_signature_two VARCHAR(500);
COMMENT ON COLUMN t_hazard_license.power_unit_signature_two IS '供电单位签字(危险确认签字)';

# 添加供电单位相关负责人姓名(危险确认签字)字段
ALTER TABLE t_hazard_license ADD COLUMN power_unit_create_name_two VARCHAR(255);
COMMENT ON COLUMN t_hazard_license.power_unit_create_name_two IS '供电单位相关负责人姓名(危险确认签字)';

# 添加供电单位相关负责人id(危险确认签字)字段
ALTER TABLE t_hazard_license ADD COLUMN power_unit_create_by_two VARCHAR(255);
COMMENT ON COLUMN t_hazard_license.power_unit_create_by_two IS '供电单位相关负责人id(危险确认签字)';


# 20250516至20250523上线修改

# 字典值修改
update t_sys_dict_data set status = '0'
where dict_data_id in('070ddfb613c546ebb6e00a84386ee519','e8225810471c448abcfca87842952d7d','2d3e648250cb4c27aae5383ce24383c0')

# 添加阶段字段
ALTER TABLE t_hazard_condition_confirmation_details ADD COLUMN stage VARCHAR(500);
COMMENT ON COLUMN t_hazard_condition_confirmation_details.stage IS '阶段';

# 添加作业步骤字段
ALTER TABLE t_hazard_condition_confirmation_details ADD COLUMN work_step VARCHAR(500);
COMMENT ON COLUMN t_hazard_condition_confirmation_details.work_step IS '作业步骤';

# 添加存在的主要风险字段
ALTER TABLE t_hazard_condition_confirmation_details ADD COLUMN major_risk VARCHAR(500);
COMMENT ON COLUMN t_hazard_condition_confirmation_details.major_risk IS '存在的主要风险';

# 添加可能的事故/后果字段
ALTER TABLE t_hazard_condition_confirmation_details ADD COLUMN consequence VARCHAR(500);
COMMENT ON COLUMN t_hazard_condition_confirmation_details.consequence IS '可能的事故/后果';

# 添加现有控制措施字段
ALTER TABLE t_hazard_condition_confirmation_details ADD COLUMN control_measures VARCHAR(500);
COMMENT ON COLUMN t_hazard_condition_confirmation_details.control_measures IS '现有控制措施';

# 值班日期类型修改
ALTER TABLE t_sys_duty ALTER COLUMN duty_date TYPE varchar(255) USING duty_date::varchar;



# 20250611上线
# 教育培训人员类型支持多选
ALTER TABLE t_train_project
ALTER COLUMN visit_type TYPE varchar(1000);


# 修改 act_id_group(公司测试环境使用)
CREATE OR REPLACE VIEW ACT_ID_GROUP AS
SELECT NULL
:: text AS REV_,
concat_text (
VARIADIC ARRAY [( r.tree_level ):: text, '-' :: text, ( r.role_id ):: text ]) AS ID_,
CASE

		WHEN ( r.tree_level = ( 1 ):: NUMERIC ) THEN
		concat_text (
		VARIADIC ARRAY [ '总公司' :: text, '-' :: text, ( r.role_name ):: text ]) 
		WHEN ( r.tree_level = ( 2 ):: NUMERIC ) THEN
		concat_text (
		VARIADIC ARRAY [ '大区/平台' :: text, '-' :: text, ( r.role_name ):: text ]) 
		WHEN ( r.tree_level = ( 3 ):: NUMERIC ) THEN
		concat_text (
		VARIADIC ARRAY [ '经营部' :: text, '-' :: text, ( r.role_name ):: text ])
		WHEN ( r.tree_level = ( 4 ):: NUMERIC ) THEN
		concat_text (
		VARIADIC ARRAY [ '基层企业' :: text, '-' :: text, ( r.role_name ):: text ])
		ELSE ( r.role_name ):: text 
	END AS NAME_,
	r.tree_level AS TYPE_ 
FROM
t_sys_role r
WHERE
(((
r.STATUS
):: INTEGER = 0
)
AND ( r.tree_level IS NOT NULL ))
ORDER BY
r.tree_level NULLS FIRST;


# 修改 act_id_group(客户环境使用)
CREATE OR REPLACE VIEW ACT_ID_GROUP AS
SELECT
NULL::text AS REV_,
CONCAT(r.tree_level::text, '-', r.role_id::text) AS ID_,
CASE
WHEN r.tree_level = 1 THEN CONCAT('总公司-', r.role_name)
WHEN r.tree_level = 2 THEN CONCAT('大区/平台-', r.role_name)
WHEN r.tree_level = 3 THEN CONCAT('经营部-', r.role_name)
WHEN r.tree_level = 4 THEN CONCAT('基层企业-', r.role_name)
ELSE r.role_name::text
END AS NAME_,
r.tree_level AS TYPE_
FROM t_sys_role r
WHERE r.STATUS::integer = 0
AND r.tree_level IS NOT NULL
ORDER BY r.tree_level NULLS FIRST;




# 修改 act_id_user
CREATE OR REPLACE VIEW act_id_user AS
SELECT
su.user_id AS ID_,
NULL :: text AS REV_,
su.user_name AS FIRST_,
su.phone_no :: text AS LAST_,
su.email AS EMAIL_,
su.login_pwd AS PWD_,
NULL :: text AS PICTURE_ID_
FROM
t_sys_user su;



# 已上上线
# 承包商所属企业多选
ALTER TABLE t_contractor_ledger
ALTER COLUMN org_id TYPE TEXT;

# 东北港口平台大区发起危险作业走的流程和散粮部一样
update t_sys_config set config_value = '51555a47ff6a42c0a75814fee3e60676,5c7b5e799ae6482bae0ca375e64210de,640323dc46334c8d8467a6d1889f90b1,74ba35d937a3403ca59e37d238a0d93f,bf729a8807ae4804baf5b719889a1b10,dafc181b7b314f8fb26c277afcbfeafc,8be46ac128e24c658ebc890f9da7818a,1335dbc3f81b4919bf59014fede4819d'
where config_id = '1'


# t_hazard_work_plan 的 license_check_user 修改成 text
ALTER TABLE t_hazard_work_plan
ALTER COLUMN license_check_user TYPE TEXT;


# 20250815后上线需更改
ALTER TABLE public.t_safe_check_plan ALTER COLUMN start_date TYPE timestamp USING start_date::timestamp;
ALTER TABLE public.t_safe_check_plan ALTER COLUMN end_date TYPE timestamp USING start_date::timestamp;
