package com.testor.ddd.safetyControl.domain.riskMap.service.impl;

import com.testor.ddd.safetyControl.domain.riskMap.entity.TSafeRiskMapElementRepo;
import com.testor.ddd.safetyControl.domain.riskMap.service.RiskMapElementService;
import com.testor.ddd.safetyControl.interfaces.model.dto.riskMap.TSafeRiskMapElementDTO;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

@Service
public class RiskMapElementServiceImpl implements RiskMapElementService {

    @Resource
    private TSafeRiskMapElementRepo riskMapElementRepo;
    public BaseResponse editRiskMapElement(String riskBizId, List<TSafeRiskMapElementDTO> riskMapElementDtoList) throws RuntimeException {
        BaseResponse baseResponse = new BaseResponse<>();

        boolean deleteResult = riskMapElementRepo.deleteByRiskBizId(riskBizId);
        if(riskMapElementDtoList == null || riskMapElementDtoList.size() == 0) {
            return baseResponse;
        }

        riskMapElementDtoList.forEach(riskMapElementDTO -> {
            riskMapElementDTO.setMapId(riskBizId);
        });
        boolean saveResult = riskMapElementRepo.saveBatch(riskMapElementDtoList);
        if(!saveResult) {
            throw new RuntimeException("更新风险地图元素失败");
        }
        return baseResponse;
    }

}
