package com.testor.ddd.safetyControl.domain.riskStatistics.entity;

import com.testor.ddd.safetyControl.interfaces.model.dto.riskStatistics.RiskStatisticsDTO;
import com.testor.ddd.safetyControl.interfaces.model.vo.riskStatistics.RiskStatisticsNumVO;

import java.util.List;

/**
 * 危险源Mapper接口
 *
 * @author testor-framework
 * @date 2022-07-11 10:00:17
 */
public interface RiskStatisticsRepo
{
    /**
     * 危险源数据统计
     * @param param
     * @return
     */
    List<RiskStatisticsNumVO> statisticsSourceNum(RiskStatisticsDTO param);

    /**
     * 危险源数据统计(根据车间场所类型分组)
     * @param param
     * @return
     */
    List<RiskStatisticsNumVO> statisticsSourceNumBySpaceType(RiskStatisticsDTO param);

    /**
     * 危险源等级统计
     * @param param
     * @return
     */
    List<RiskStatisticsNumVO> statisticsSourceLevel(RiskStatisticsDTO param);

    /**
     * 危险源类型统计
     * @param param
     * @return
     */
    List<RiskStatisticsNumVO> statisticsSourceType(RiskStatisticsDTO param);
    /**
     * 风险点数据统计
     * @param param
     * @return
     */
    List<RiskStatisticsNumVO> statisticsPointNum(RiskStatisticsDTO param);

    /**
     * 风险点数据统计(根据车间场所类型分组)
     * @param param
     * @return
     */
    List<RiskStatisticsNumVO> statisticsPointNumBySpaceType(RiskStatisticsDTO param);

    /**
     * 风险点等级统计
     * @param param
     * @return
     */
    List<RiskStatisticsNumVO> statisticsPointLevel(RiskStatisticsDTO param);

    /**
     * 风险点类型统计
     * @param param
     * @return
     */
    List<RiskStatisticsNumVO> statisticsPointType(RiskStatisticsDTO param);

}
