package com.testor.module.contractor.ledger.model.template;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.NumberFormat;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.testor.common.annotation.ExcelDictFormat;
import com.testor.common.annotation.ExcelSelected;
import com.testor.common.constant.ExcelSelectConstant;
import com.testor.common.convert.ExcelDictConvert;
import com.testor.common.core.annotation.Excel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.checkerframework.checker.units.qual.min;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 工器具导入模板实体
 */

@Data
public class ToolsTemplate {
    /**
     * 工器具名称
     */
    @ExcelProperty(value = "工器具名称", index = 0)
    @NotBlank(message = "工器具名称不能为空")
    @ColumnWidth(value = 20)
    private String toolsName;

    /**
     * 类别id（数据字典id）
     */
    @ExcelProperty(value = "类别",converter = ExcelDictConvert.class, index = 1)
    @ExcelDictFormat(dictType = "contractor_tools_type")
    @ExcelSelected(type = ExcelSelectConstant.DICT_DATA_BY_TYPE, param = "contractor_tools_type")
    @NotBlank(message = "类别不能为空")
    @ColumnWidth(value = 20)
    private String typeId;

    /**
     * 型号
     */
    @ExcelProperty(value = "型号", index = 2)
    @NotBlank(message = "型号不能为空")
    @ColumnWidth(value = 20)
    private String model;

    /**
     * 数量
     */
    @ExcelProperty(value = "数量",index = 3)
    @NotNull(message = "数量不能为空")
    @Min(value = 1,message = "数量不能小于1")
    @Max(value = 99999L,message = "数量不能大于99999")
    @ColumnWidth(value = 20)
    private Long num;
    /**
     * 用途
     */
    @ExcelProperty(value = "用途",index = 4)
    @NotBlank(message = "用途不能为空")
    @ColumnWidth(value = 20)
    private String purpose;

    /**
     * 检查情况 0未检查 1已检查
     */
    @ExcelProperty(value = "检查情况",converter = ExcelDictConvert.class, index = 5)
    @ExcelSelected(source = {"未检查", "已检查"})
    @ExcelDictFormat(readConverterExp = "0=未检查,1=已检查")
    @NotBlank(message = "检查情况不能为空")
    @ColumnWidth(value = 20)
    private String checkStatus;

    /**
     * 检查日期
     */
    @ExcelProperty(value = "检查日期",index = 6)
    @NotNull(message = "检查日期不能为空")
    @ColumnWidth(value = 20)
    private Date checkTime;

    /**
     * 是否合格 0 不合格 1 合格
     */
    @ExcelProperty(value = "是否合格",converter = ExcelDictConvert.class, index = 7)
    @ExcelSelected(source = {"不合格", "合格"})
    @ExcelDictFormat(readConverterExp = "0=不合格,1=合格")
    @NotBlank(message = "是否合格不能为空")
    @ColumnWidth(value = 20)
    private String isPass;

    @ExcelProperty(value = "备注", index = 8)
    @ColumnWidth(value = 20)
    private String remarks;
}
