package com.testor.module.contractor.manage.model.domain;

import java.time.LocalDateTime;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;


/**
 * 开工准备-风险分析和控制措施对象 t_contractor_preparation_analysis
 * 
 * @author testor-framework
 * @date 2024-11-24 13:19:48
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_contractor_preparation_analysis")
@ApiModel(value = "TContractorPreparationAnalysis对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TContractorPreparationAnalysis extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * 主键id
 */
  @ApiModelProperty(value = "主键id")

  @TableId("id")
  private String id;
/**
 * 开工准备id
 */
  @ApiModelProperty(value = "开工准备id")

  @TableField("preparation_id")
  private String preparationId;
/**
 * 工作场所
 */
  @ApiModelProperty(value = "工作场所")

  @TableField("workplace")
  private String workplace;
/**
 * 活动名称
 */
  @ApiModelProperty(value = "活动名称")

  @TableField("activity_name")
  private String activityName;
/**
 * 危险源描述
 */
  @ApiModelProperty(value = "危险源描述")

  @TableField("hazard_description")
  private String hazardDescription;
/**
 * 可能导致的后果
 */
  @ApiModelProperty(value = "可能导致的后果")

  @TableField("potential_accident_consequences")
  private String potentialAccidentConsequences;
/**
 * 控制措施
 */
  @ApiModelProperty(value = "控制措施")

  @TableField("control_measures")
  private String controlMeasures;
/**
 * 责任人
 */
  @ApiModelProperty(value = "责任人id")

  @TableField("person_id")
  private String personId;

  @ApiModelProperty(value = "责任人")
  @TableField(exist = false)
  private String personName;

  public static final String ID ="id";
  public static final String PREPARATION_ID ="preparation_id";
  public static final String WORKPLACE ="workplace";
  public static final String ACTIVITY_NAME ="activity_name";
  public static final String HAZARD_DESCRIPTION ="hazard_description";
  public static final String POTENTIAL_ACCIDENT_CONSEQUENCES ="potential_accident_consequences";
  public static final String CONTROL_MEASURES ="control_measures";
  public static final String PERSON_ID ="person_id";


}
