package com.testor.module.hazard.dao;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.testor.module.hazard.model.domain.TContractorAccessLogApproval;
import com.tongtech.tfw.backend.common.models.supers.SuperDao;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 承包商准入管理访问日志审批表Mapper接口
 *
 * @author testor-framework
 * @date 2025-01-20
 */
@Mapper
public interface TContractorAccessLogApprovalDao extends BaseMapper<TContractorAccessLogApproval>, SuperDao<TContractorAccessLogApproval> {


    /**
     * 根据合同准入管理ID和创建人查询审批记录
     *
     * @param contractorAllowId 合同准入管理ID
     * @param createBy 创建人
     * @return 审批记录
     */
    List<TContractorAccessLogApproval> selectByContractorAllowIdAndCreateBy(@Param("contractorAllowId") String contractorAllowId, @Param("createBy") String createBy);

     /**
     * 根据合同准入管理ID和审批状态查询审批记录数量
     *
     * @param contractorAllowId 合同准入管理ID
     * @param approvalStatus 审批状态
     * @return 审批记录数量
     */
    @Select("select count(1) from t_contractor_access_log_approval\n" +
            "where contractor_allow_id = #{contractorAllowId} and approval_status = #{approvalStatus}")
    int selectCountByContractorAllowIdAndApprovalStatus(@Param("contractorAllowId") String contractorAllowId, @Param("approvalStatus") String approvalStatus);

    /**
     * 批量更新审批状态
     *
     * @param ids
     * @param approvalStatus 审批状态
     * @return 更新数量
     */
    int updateApprovalStatus(@Param("ids") List<String> ids, @Param("approvalStatus") String approvalStatus);

}
