package com.testor.module.hazard.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.hazard.model.domain.TContractorAccessLog;
import com.testor.module.hazard.model.domain.TContractorAccessLogApproval;
import com.testor.module.hazard.model.dto.TContractorAccessLogApprovalParam;
import com.testor.module.hazard.model.dto.TContractorAccessLogParam;
import com.tongtech.tfw.backend.common.models.supers.SuperService;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

public interface TContractorAccessLogApprovalService extends SuperService<TContractorAccessLogApproval> {

    /**
     * 批量插入
     * @param tContractorAccessLogApprovals
     */
    void insertBatchContractorAccessLog(List<TContractorAccessLogApproval> tContractorAccessLogApprovals);

    /**
     * 查询承包商访问日志审批
     * @param param
     * @return
     */
    Page<TContractorAccessLogApproval> queryContractorAccessLogApproval(TContractorAccessLogApprovalParam param);

    /**
     * 根据合同准入管理ID和创建人查询审批记录
     *
     * @param contractorAllowId 合同准入管理ID
     * @param createBy 创建人
     * @return 审批记录
     */
    List<TContractorAccessLogApproval> selectByContractorAllowIdAndCreateBy(String contractorAllowId,String createBy);


    /**
     * 根据合同准入管理ID和审批状态查询审批记录数量
     *
     * @param contractorAllowId 合同准入管理ID
     * @param approvalStatus 审批状态
     * @return 审批记录数量
     */
    int selectCountByContractorAllowIdAndApprovalStatus(String contractorAllowId,String approvalStatus);


    /**
     * 批量更新审批状态
     *
     * @param ids
     * @param approvalStatus 审批状态
     * @return 更新数量
     */
    int updateApprovalStatus(List<String> ids,String approvalStatus);


}
